---
generated_at: 2025-12-26 12:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：337-マイ休暇詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **URLパスの正確性**：クラスター構成から推定
  2. **メッセージ内容の実際の文言**：言語ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/MyTime/Resources/MyTimeOffResource/Pages/ViewMyTimeOff.php`
- E-02: `plugins/webkul/time-off/src/Filament/Clusters/MyTime/Resources/MyTimeOffResource.php`
- E-03: `plugins/webkul/time-off/src/Filament/Clusters/Management/Resources/TimeOffResource.php`
- E-04: `plugins/webkul/time-off/src/Models/Leave.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はViewRecordを継承 | E-01 (line 8-13) | ○ |
| C-02 | HasRecordNavigationTabsトレイトを使用 | E-01 (line 15) | ○ |
| C-03 | ChatterActionがある | E-01 (line 22-23) | ○ |
| C-04 | EditActionがある | E-01 (line 24) | ○ |
| C-05 | DeleteActionがある | E-01 (line 25-31) | ○ |
| C-06 | 削除成功時に通知を表示 | E-01 (line 26-30) | ○ |
| C-07 | infolist定義がある | E-02 (line 74-124) | ○ |
| C-08 | holidayStatus.nameにcalendarアイコン | E-02 (line 82-84) | ○ |
| C-09 | request_unit_halfにclockアイコン | E-02 (line 85-88) | ○ |
| C-10 | request_date_fromにcalendarアイコン | E-02 (line 89-92) | ○ |
| C-11 | request_date_toは半日休暇時に非表示 | E-02 (line 93-97) | ○ |
| C-12 | request_date_from_periodは半日休暇時に表示 | E-02 (line 98-101) | ○ |
| C-13 | private_nameにdocument-textアイコン | E-02 (line 102-104) | ○ |
| C-14 | duration_displayにcalendar-daysアイコン | E-02 (line 105-117) | ○ |
| C-15 | attachmentはImageEntryで表示 | E-02 (line 118-120) | ○ |
| C-16 | attachmentはsupport_document時に表示 | E-02 (line 120) | ○ |
| C-17 | 半日休暇時は0.5日と表示 | E-02 (line 108-109) | ○ |
| C-18 | 日数計算はdiffInDays+1 | E-02 (line 112-115) | ○ |
| C-19 | Leaveモデルを使用 | E-02 (line 27), E-04 | ○ |
| C-20 | MyTimeクラスターに属する | E-02 (line 33) | ○ |
| C-21 | URLパスの正確性 | **根拠なし** | △ |
| C-22 | メッセージ内容の具体的な文言 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 正確なURLパスはルーティング設定を確認する必要がある
  - 候補：`routes/web.php` / Filamentのルーティング設定
- 言語ファイル（notification.title, notification.body等）の実際の内容
  - 候補：`lang/ja/time-off.php` / `resources/lang/`ディレクトリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 表示項目の設定内容（コードから正確に読み取り可能）
- 0: 低リスク - ヘッダーアクション（コードから確認済み）
- 1: 中リスク - URLパス（クラスター構成から推定）

## 6) レビュアーチェックリスト（最小）
- [ ] 実際のURLパスを確認
- [ ] 言語ファイルの通知メッセージを確認
- [ ] チャット機能の動作確認
- [ ] 添付ファイル表示の動作確認
- [ ] 半日休暇時の表示切り替え確認
