---
generated_at: 2025-12-26 12:35:00
metrics:
  claims_total: 28
  claims_with_evidence: 26
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：338-マイ割当一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：26 / 28、根拠なし：2
- 優先レビュー（高）
  1. **URLパスの正確性**：クラスター構成から推定
  2. **メッセージ内容の実際の文言**：言語ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/MyTime/Resources/MyAllocationResource/Pages/ListMyAllocations.php`
- E-02: `plugins/webkul/time-off/src/Filament/Clusters/MyTime/Resources/MyAllocationResource.php`
- E-03: `plugins/webkul/time-off/src/Models/LeaveAllocation.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はListRecordsを継承 | E-01 (line 6-9) | ○ |
| C-02 | ヘッダーにCreateActionがある | E-01 (line 14-17) | ○ |
| C-03 | holidayStatus.nameカラムがある | E-02 (line 143-146) | ○ |
| C-04 | number_of_daysカラムがある | E-02 (line 147-150) | ○ |
| C-05 | allocation_typeカラムがある | E-02 (line 151-155) | ○ |
| C-06 | stateカラムがある | E-02 (line 156-161) | ○ |
| C-07 | グループ化オプションが5種類 | E-02 (line 163-179) | ○ |
| C-08 | approveアクションがある | E-02 (line 191-214) | ○ |
| C-09 | refuseアクションがある | E-02 (line 215-228) | ○ |
| C-10 | ViewActionがある | E-02 (line 182) | ○ |
| C-11 | EditActionがある | E-02 (line 183) | ○ |
| C-12 | DeleteActionがある | E-02 (line 184-190) | ○ |
| C-13 | DeleteBulkActionがある | E-02 (line 232-239) | ○ |
| C-14 | LeaveAllocationモデルを使用 | E-02 (line 41), E-03 | ○ |
| C-15 | MyTimeクラスターに属する | E-02 (line 45) | ○ |
| C-16 | navigationSortは3 | E-02 (line 47) | ○ |
| C-17 | navigationIconはheroicon-o-calendar | E-02 (line 43) | ○ |
| C-18 | stateはバッジ形式 | E-02 (line 159) | ○ |
| C-19 | allocation_typeはEnumでフォーマット | E-02 (line 152) | ○ |
| C-20 | 承認時はVALIDATE_TWOに更新 | E-02 (line 196-199) | ○ |
| C-21 | 却下時はREFUSEに更新 | E-02 (line 220) | ○ |
| C-22 | modifyQueryUsingでフィルタ | E-02 (line 242-244) | ○ |
| C-23 | employee_idでフィルタ | E-02 (line 243) | ○ |
| C-24 | 承認済みの場合approveは非表示 | E-02 (line 194) | ○ |
| C-25 | 却下済みの場合refuseは非表示 | E-02 (line 217) | ○ |
| C-26 | AllocationType Enumを使用 | E-02 (line 30), E-03 (line 79) | ○ |
| C-27 | URLパスの正確性 | **根拠なし** | △ |
| C-28 | メッセージ内容の具体的な文言 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 正確なURLパスはルーティング設定を確認する必要がある
  - 候補：`routes/web.php` / Filamentのルーティング設定
- 言語ファイル（notification.title, notification.body等）の実際の内容
  - 候補：`lang/ja/time-off.php` / `resources/lang/`ディレクトリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テーブルカラムの設定内容（コードから正確に読み取り可能）
- 0: 低リスク - アクション定義（コードから確認済み）
- 1: 中リスク - URLパス（クラスター構成から推定）

## 6) レビュアーチェックリスト（最小）
- [ ] 実際のURLパスを確認
- [ ] 言語ファイルの通知メッセージを確認
- [ ] 承認・却下アクションの動作確認
- [ ] ログインユーザーでのフィルタリング動作確認
