---
generated_at: 2025-12-26 12:40:00
metrics:
  claims_total: 30
  claims_with_evidence: 28
  claims_without_evidence: 2
confidence_derived: 0.93
---

# 根拠レポート：339-マイ割当作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：28 / 30、根拠なし：2
- 優先レビュー（高）
  1. **URLパスの正確性**：クラスター構成から推定
  2. **メッセージ内容の実際の文言**：言語ファイル未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/MyTime/Resources/MyAllocationResource/Pages/CreateMyAllocation.php`
- E-02: `plugins/webkul/time-off/src/Filament/Clusters/MyTime/Resources/MyAllocationResource.php`
- E-03: `plugins/webkul/time-off/src/Models/LeaveAllocation.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面はCreateRecordを継承 | E-01 (line 6-11) | ○ |
| C-02 | 作成後は詳細画面へリダイレクト | E-01 (line 24-26) | ○ |
| C-03 | 作成成功時に通知を表示 | E-01 (line 28-34) | ○ |
| C-04 | mutateFormDataBeforeCreateでデータ加工 | E-01 (line 36-55) | ○ |
| C-05 | 従業員チェックがある | E-01 (line 38-50) | ○ |
| C-06 | 従業員未登録時は警告通知 | E-01 (line 41-47) | ○ |
| C-07 | 従業員未登録時はhaltで処理中断 | E-01 (line 48) | ○ |
| C-08 | employee_idを自動設定 | E-01 (line 53) | ○ |
| C-09 | サブナビゲーションが表示される | E-01 (line 13-20) | ○ |
| C-10 | フォーム定義がある | E-02 (line 61-137) | ○ |
| C-11 | ProgressStepperコンポーネントがある | E-02 (line 67-88) | ○ |
| C-12 | stateのデフォルトはconfirm | E-02 (line 84) | ○ |
| C-13 | nameフィールドがある | E-02 (line 94-97) | ○ |
| C-14 | holiday_status_idフィールドがある | E-02 (line 98-105) | ○ |
| C-15 | allocation_typeフィールドがある | E-02 (line 107-111) | ○ |
| C-16 | allocation_typeはRadio | E-02 (line 107) | ○ |
| C-17 | allocation_typeのデフォルトはregular | E-02 (line 110) | ○ |
| C-18 | 有効期間はFieldset | E-02 (line 112-123) | ○ |
| C-19 | date_fromフィールドがある | E-02 (line 114-118) | ○ |
| C-20 | date_fromのデフォルトはnow() | E-02 (line 118) | ○ |
| C-21 | date_toフィールドがある | E-02 (line 119-122) | ○ |
| C-22 | number_of_daysフィールドがある | E-02 (line 124-131) | ○ |
| C-23 | number_of_daysのデフォルトは0 | E-02 (line 127) | ○ |
| C-24 | number_of_daysの最大値は99999999999 | E-02 (line 129) | ○ |
| C-25 | notesフィールドがある | E-02 (line 132-133) | ○ |
| C-26 | notesはRichEditor | E-02 (line 132) | ○ |
| C-27 | LeaveAllocationモデルを使用 | E-02 (line 41), E-03 | ○ |
| C-28 | AllocationType Enumを使用 | E-02 (line 30, 109) | ○ |
| C-29 | URLパスの正確性 | **根拠なし** | △ |
| C-30 | メッセージ内容の具体的な文言 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 正確なURLパスはルーティング設定を確認する必要がある
  - 候補：`routes/web.php` / Filamentのルーティング設定
- 言語ファイル（notification.title, notification.body等）の実際の内容
  - 候補：`lang/ja/time-off.php` / `resources/lang/`ディレクトリ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム項目の設定内容（コードから正確に読み取り可能）
- 0: 低リスク - バリデーション処理（コードから確認済み）
- 1: 中リスク - URLパス（クラスター構成から推定）
- 0: 低リスク - 従業員チェック処理（コードから確認済み）

## 6) レビュアーチェックリスト（最小）
- [ ] 実際のURLパスを確認
- [ ] 言語ファイルの通知メッセージを確認
- [ ] 従業員未登録時の警告動作確認
- [ ] ProgressStepperの表示確認
- [ ] 割当タイプのラジオ選択確認
