---
generated_at: 2025-12-26 18:15:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：34-支払条件作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/accounts/src/Filament/Resources/PaymentTermResource/Pages/CreatePaymentTerm.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/PaymentTermResource.php`
- E-03: `plugins/webkul/accounts/src/Models/PaymentTerm.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `plugins/webkul/accounts/src/Enums/EarlyPayDiscount.php`（参照のみ）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「支払条件作成」 | E-04 | ○ |
| C-02 | URLパターンは `/payment-terms/create` | E-02 (getPages) | ○ |
| C-03 | CreateRecordを継承 | E-01 | ○ |
| C-04 | 保存後は詳細画面へリダイレクト | E-01 (getRedirectUrl) | ○ |
| C-05 | 保存時に成功通知を表示 | E-01 (getCreatedNotification) | ○ |
| C-06 | mutateFormDataBeforeCreateでcreator_idを設定 | E-01 | ○ |
| C-07 | mutateFormDataBeforeCreateでcompany_idを設定 | E-01 | ○ |
| C-08 | nameフィールドが必須 | E-02 (form, required) | ○ |
| C-09 | nameフィールドに大きめフォントスタイル | E-02 (extraInputAttributes) | ○ |
| C-10 | early_discountトグルがLive設定 | E-02 (form, live) | ○ |
| C-11 | 割引関連フィールドはearly_discount有効時のみ表示 | E-02 (visible条件) | ○ |
| C-12 | discount_percentageに0-100の制約 | E-02 (minValue, maxValue) | ○ |
| C-13 | discount_daysに0以上の制約 | E-02 (minValue) | ○ |
| C-14 | early_pay_discountにEarlyPayDiscount列挙型 | E-02 (form) | ○ |
| C-15 | early_pay_discountのデフォルトはINCLUDED | E-02 (default) | ○ |
| C-16 | noteはRichEditorコンポーネント | E-02 (RichEditor) | ○ |
| C-17 | テーブル名はaccounts_payment_terms | E-03 ($table) | ○ |
| C-18 | SortableTraitを使用 | E-03 (use SortableTrait) | ○ |
| C-19 | 作成時にPaymentDueTermが自動作成される | E-03 (boot, created) | ○ |
| C-20 | PaymentDueTermのデフォルト値（value_amount: 100等） | E-03 (boot) | ○ |
| C-21 | 多言語通知メッセージを使用 | E-01 (言語キー使用) | ○ |
| C-22 | 2カラムレイアウト | E-02 (columns(2)) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム構造と入力項目
- 0: 低リスク - DB更新処理
- 0: 低リスク - 自動生成されるPaymentDueTermのデフォルト値

## 6) レビュアーチェックリスト（最小）
- [ ] EarlyPayDiscount列挙型の全オプションを確認
- [ ] 多言語ファイルの通知メッセージ内容を確認
- [ ] PaymentDueTerm自動作成後の編集フローを確認
