---
generated_at: 2025-12-26 18:50:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：341-マイ割当詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **URL/ルーティングパス**：ルーティング定義の直接確認が必要
  2. **権限制御の詳細**：ポリシー・ゲート定義の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/MyTime/Resources/MyAllocationResource/Pages/ViewMyAllocation.php`
- E-02: `plugins/webkul/time-off/src/Filament/Clusters/MyTime/Resources/MyAllocationResource.php`
- E-03: `plugins/webkul/time-off/src/Models/LeaveAllocation.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ViewMyAllocationクラスはViewRecordを継承 | E-01 | ○ |
| C-02 | HasRecordNavigationTabsトレイトを使用 | E-01 | ○ |
| C-03 | ヘッダーアクションにChatter、Edit、Deleteが存在 | E-01 | ○ |
| C-04 | 削除通知はローカライズキーを使用 | E-01 | ○ |
| C-05 | InfolistはGrid 3カラムレイアウト | E-02 | ○ |
| C-06 | 割当詳細セクションにname、holidayStatus.name、allocation_typeを表示 | E-02 | ○ |
| C-07 | 有効期間セクションにdate_from、date_to、notesを表示 | E-02 | ○ |
| C-08 | 割当ステータスセクションにnumber_of_days、stateを表示 | E-02 | ○ |
| C-09 | allocation_typeはAllocationType Enumを使用 | E-02, E-03 | ○ |
| C-10 | stateはState Enumを使用 | E-02 | ○ |
| C-11 | テーブル名はtime_off_leave_allocations | E-03 | ○ |
| C-12 | employee_idでユーザーフィルタリング | E-02 | ○ |
| C-13 | MyTimeクラスターに属する | E-02 | ○ |
| C-14 | navigationSort = 3 | E-02 | ○ |
| C-15 | モデルはLeaveAllocation | E-02, E-03 | ○ |
| C-16 | 画面機能マッピングにFN-TOFF-010として記載 | E-06 | ○ |
| C-17 | URLパスは/time-off/my-time/my-allocations/{record} | **推定** | △ |
| C-18 | 権限制御はemployee_idのみ | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- URLパスの正確な定義
  - 候補：routes/web.php / Filament Panel Provider / Resource定義
- 権限ポリシーの詳細
  - 候補：Policy クラス / Gate 定義 / Middleware

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な画面構成、表示項目
- 1: 中リスク - URLパスの推定値、権限制御の詳細

## 6) レビュアーチェックリスト（最小）
- [ ] ViewMyAllocation.phpのヘッダーアクション定義を確認
- [ ] MyAllocationResource.phpのinfolistメソッドを確認
- [ ] LeaveAllocationモデルのfillable/castsを確認
- [ ] 権限制御の実装（ポリシー/ゲート）を確認
- [ ] 実際のURLパスをブラウザで確認
