---
generated_at: 2025-12-26 18:58:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：345-休暇管理詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **URLパス**：ルーティング定義の直接確認が必要
  2. **権限制御**：ポリシー定義の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/Management/Resources/TimeOffResource/Pages/ViewTimeOff.php`
- E-02: `plugins/webkul/time-off/src/Filament/Clusters/Management/Resources/TimeOffResource.php`
- E-03: `plugins/webkul/time-off/src/Models/Leave.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ViewTimeOffクラスはViewRecordを継承 | E-01 | ○ |
| C-02 | ヘッダーアクションにChatter、Edit、Deleteが存在 | E-01 | ○ |
| C-03 | サブナビゲーションがクラスターから生成される | E-01 | ○ |
| C-04 | 削除通知がローカライズキーを使用 | E-01 | ○ |
| C-05 | InfolistはGroup/Sectionで構成 | E-02 | ○ |
| C-06 | holidayStatus.nameが表示される | E-02 | ○ |
| C-07 | request_unit_halfがYes/Noで表示 | E-02 | ○ |
| C-08 | request_date_from、request_date_toが表示される | E-02 | ○ |
| C-09 | private_nameが表示される | E-02 | ○ |
| C-10 | duration_displayが表示される | E-02 | ○ |
| C-11 | attachmentがImageEntryで表示 | E-02 | ○ |
| C-12 | 表示条件にsupport_documentフラグを使用 | E-02 | ○ |
| C-13 | Managementクラスターに属する | E-02 | ○ |
| C-14 | 画面機能マッピングにFN-TOFF-004として記載 | E-05 | ○ |
| C-15 | URLパスは/time-off/management/time-offs/{record} | **推定** | △ |
| C-16 | 管理権限が必要 | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- URLパスの正確な定義
- 権限ポリシーの詳細

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 表示項目、ヘッダーアクション
- 1: 中リスク - URLパス、権限制御

## 6) レビュアーチェックリスト（最小）
- [ ] ViewTimeOff.phpのヘッダーアクション定義を確認
- [ ] TimeOffResource.phpのinfolist()メソッドを確認
- [ ] 表示条件（request_unit_half、support_document）の動作を確認
- [ ] 実際の画面表示を確認
