---
generated_at: 2025-12-26 19:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：346-割当管理一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **URLパス**：ルーティング定義の直接確認が必要
  2. **権限制御**：ポリシー定義の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/Management/Resources/AllocationResource/Pages/ListAllocations.php`
- E-02: `plugins/webkul/time-off/src/Filament/Clusters/Management/Resources/AllocationResource.php`
- E-03: `plugins/webkul/time-off/src/Models/LeaveAllocation.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ListAllocationsクラスはListRecordsを継承 | E-01 | ○ |
| C-02 | HasTableViewsトレイトを使用 | E-01 | ○ |
| C-03 | 7つのプリセットビューが定義されている | E-01 | ○ |
| C-04 | Waiting For Meがデフォルトビュー | E-01 | ○ |
| C-05 | CreateActionにheroicon-o-plus-circleアイコン | E-01 | ○ |
| C-06 | テーブルに5つのカラムが定義 | E-02 | ○ |
| C-07 | 5つのグループ化オプションが存在 | E-02 | ○ |
| C-08 | 行アクションにview、edit、delete、approve、refuseが存在 | E-02 | ○ |
| C-09 | 承認アクションでstateをVALIDATE_TWOに更新 | E-02 | ○ |
| C-10 | 拒否アクションでstateをREFUSEに更新 | E-02 | ○ |
| C-11 | BulkActionGroupにDeleteBulkActionが存在 | E-02 | ○ |
| C-12 | Managementクラスターに属する | E-02 | ○ |
| C-13 | navigationSort = 2 | E-02 | ○ |
| C-14 | モデルはLeaveAllocation | E-02, E-03 | ○ |
| C-15 | テーブル名はtime_off_leave_allocations | E-03 | ○ |
| C-16 | StateはEnumを使用 | E-03 | ○ |
| C-17 | AllocationTypeはEnumを使用 | E-02, E-03 | ○ |
| C-18 | マイチームビューはleave_manager_idでフィルタ | E-01 | ○ |
| C-19 | Currently ValidビューはdateでフィルタリUng | E-01 | ○ |
| C-20 | 画面機能マッピングにFN-TOFF-005として記載 | E-05 | ○ |
| C-21 | URLパスは/time-off/management/allocations | **推定** | △ |
| C-22 | 管理権限が必要 | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- URLパスの正確な定義
- 権限ポリシーの詳細

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テーブル構成、アクション定義
- 1: 中リスク - URLパス、権限制御

## 6) レビュアーチェックリスト（最小）
- [ ] ListAllocations.phpのプリセットビュー定義を確認
- [ ] AllocationResource.phpのtable()メソッドを確認
- [ ] LeaveAllocation.phpモデルのfillable/castsを確認
- [ ] 権限制御の実装を確認
- [ ] 実際のURLパスをブラウザで確認
