---
generated_at: 2025-12-26 18:20:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：35-支払条件編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/accounts/src/Filament/Resources/PaymentTermResource/Pages/EditPaymentTerm.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/PaymentTermResource.php`
- E-03: `plugins/webkul/accounts/src/Models/PaymentTerm.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「支払条件編集」 | E-04 | ○ |
| C-02 | URLパターンは `/payment-terms/{record}/edit` | E-02 (getPages) | ○ |
| C-03 | EditRecordを継承 | E-01 | ○ |
| C-04 | サブナビゲーションが上部に配置 | E-01 (getSubNavigationPosition) | ○ |
| C-05 | 保存後は詳細画面へリダイレクト | E-01 (getRedirectUrl) | ○ |
| C-06 | 保存時に成功通知を表示 | E-01 (getSavedNotification) | ○ |
| C-07 | ヘッダーにViewActionがある | E-01 (getHeaderActions) | ○ |
| C-08 | ヘッダーにDeleteActionがある | E-01 (getHeaderActions) | ○ |
| C-09 | 削除時に成功通知を表示 | E-01 (successNotification) | ○ |
| C-10 | mutateFormDataBeforeSaveが存在（変換なし） | E-01 | ○ |
| C-11 | フォームは作成画面と共有 | E-02 (form) | ○ |
| C-12 | nameフィールドが必須 | E-02 (form, required) | ○ |
| C-13 | early_discountトグルがLive設定 | E-02 (form, live) | ○ |
| C-14 | 割引関連フィールドはearly_discount有効時のみ表示 | E-02 (visible条件) | ○ |
| C-15 | noteはRichEditorコンポーネント | E-02 (RichEditor) | ○ |
| C-16 | SoftDeletesトレイトを使用 | E-03 (use SoftDeletes) | ○ |
| C-17 | サブナビゲーションに3つのリンク | E-02 (getRecordSubNavigation) | ○ |
| C-18 | 多言語通知メッセージを使用 | E-01 (言語キー使用) | ○ |
| C-19 | テーブル名はaccounts_payment_terms | E-03 ($table) | ○ |
| C-20 | 大きめフォントスタイルのname入力 | E-02 (extraInputAttributes) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム構造と入力項目
- 0: 低リスク - サブナビゲーション構成
- 0: 低リスク - DB更新処理

## 6) レビュアーチェックリスト（最小）
- [ ] 多言語ファイルの通知メッセージ内容を確認
- [ ] サブナビゲーションが正しく機能するか実機確認
- [ ] 早期割引の表示/非表示が正しく動作するか確認
