---
generated_at: 2025-12-26 19:08:00
metrics:
  claims_total: 16
  claims_with_evidence: 14
  claims_without_evidence: 2
confidence_derived: 0.88
---

# 根拠レポート：350-従業員別レポート

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.88**
  - 根拠あり：14 / 16、根拠なし：2
- 優先レビュー（高）
  1. **URLパス**：ルーティング定義の直接確認が必要
  2. **権限制御**：ポリシー定義の確認が必要

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/Reporting/Resources/ByEmployeeResource/Pages/ListByEmployees.php`
- E-02: `plugins/webkul/time-off/src/Filament/Clusters/Reporting/Resources/ByEmployeeResource.php`
- E-03: `plugins/webkul/time-off/src/Filament/Clusters/Management/Resources/TimeOffResource.php`
- E-04: `plugins/webkul/time-off/src/Filament/Clusters/Management/Resources/TimeOffResource/Pages/ListTimeOff.php`
- E-05: `plugins/webkul/time-off/src/Models/Leave.php`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ByEmployeeResourceはTimeOffResourceを継承 | E-02 | ○ |
| C-02 | ListByEmployeesはListTimeOffを継承 | E-01 | ○ |
| C-03 | デフォルトグループ化がemployee.name | E-02 | ○ |
| C-04 | Reportingクラスターに属する | E-02 | ○ |
| C-05 | ナビゲーションアイコンがheroicon-o-users | E-02 | ○ |
| C-06 | モデルはLeave | E-02, E-05 | ○ |
| C-07 | テーブルはparent::table()を呼び出し | E-02 | ○ |
| C-08 | 独自のローカライズキーを使用 | E-02 | ○ |
| C-09 | プリセットビューはListTimeOffから継承 | E-01, E-04 | ○ |
| C-10 | 7つのプリセットビューが存在 | E-04 | ○ |
| C-11 | 画面機能マッピングにFN-TOFF-011として記載 | E-06 | ○ |
| C-12 | 行アクション（承認、拒否、表示、編集、削除）が存在 | E-03 | ○ |
| C-13 | 一括削除アクションが存在 | E-03 | ○ |
| C-14 | テーブルカラムはTimeOffResourceから継承 | E-03 | ○ |
| C-15 | URLパスは/time-off/reporting/by-employees | **推定** | △ |
| C-16 | レポート参照権限が必要 | **要確認** | △ |

## 4) 不足情報（Unknown / Missing）
- URLパスの正確な定義
- 権限ポリシーの詳細
- Reportingクラスターの権限設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 継承関係、デフォルトグループ化
- 1: 中リスク - URLパス、権限制御

## 6) レビュアーチェックリスト（最小）
- [ ] ByEmployeeResource.phpの継承関係を確認
- [ ] ListByEmployees.phpの継承と設定を確認
- [ ] table()メソッドのdefaultGroup()を確認
- [ ] Reportingクラスターの権限設定を確認
- [ ] 実際の画面でグループ化表示を確認
