---
generated_at: 2025-12-26 18:50:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：351-休暇タイプ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **権限による表示制御の詳細**：具体的なロール設定の根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/Configurations/Resources/LeaveTypeResource.php`
- E-02: `plugins/webkul/time-off/src/Filament/Clusters/Configurations/Resources/LeaveTypeResource/Pages/ListLeaveTypes.php`
- E-03: `plugins/webkul/time-off/src/Models/LeaveType.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面一覧/画面遷移図.md`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別が一覧画面である | E-02 (ListRecords継承) | ○ |
| C-02 | URLが/time-off/configurations/leave-typesである | E-01 (getPages()) | ○ |
| C-03 | 新規作成ボタンがヘッダーに存在する | E-02 (getHeaderActions()) | ○ |
| C-04 | タブで全て/アーカイブ済みを切り替え可能 | E-02 (getTabs()) | ○ |
| C-05 | nameカラムが検索・ソート可能 | E-01 (table定義) | ○ |
| C-06 | leave_validation_typeカラムが存在する | E-01 (table定義) | ○ |
| C-07 | notifiedTimeOffOfficersがバッジ表示される | E-01 (table定義) | ○ |
| C-08 | requires_allocationがバッジ表示される | E-01 (table定義) | ○ |
| C-09 | 行アクションにView/Edit/Delete/Restoreがある | E-01 (recordActions) | ○ |
| C-10 | 一括アクションにDelete/ForceDelete/Restoreがある | E-01 (toolbarActions) | ○ |
| C-11 | ソフトデリート機能を使用している | E-03 (SoftDeletes trait) | ○ |
| C-12 | テーブル名がtime_off_leave_typesである | E-03 ($table) | ○ |
| C-13 | 会社との関連がある | E-03 (company relation) | ○ |
| C-14 | 作成者との関連がある | E-03 (createdBy relation) | ○ |
| C-15 | 通知担当者との多対多関連がある | E-03 (notifiedTimeOffOfficers) | ○ |
| C-16 | QueryBuilderフィルタが使用されている | E-01 (filters) | ○ |
| C-17 | 削除成功時に通知メッセージが表示される | E-01 (DeleteAction設定) | ○ |
| C-18 | 復元成功時に通知メッセージが表示される | E-01 (RestoreAction設定) | ○ |
| C-19 | 完全削除エラー時にエラー通知が表示される | E-01 (ForceDeleteBulkAction) | ○ |
| C-20 | カラムの並び替えが可能 | E-01 (reorderableColumns) | ○ |
| C-21 | カラム管理機能がある | E-01 (columnManagerColumns) | ○ |
| C-22 | 画面番号が351である | E-04 (画面一覧.csv) | ○ |
| C-23 | 機能IDがFN-TOFF-012である | E-06 (画面機能マッピング.csv) | ○ |
| C-24 | Sortable機能を使用している | E-03 (SortableTrait) | ○ |
| C-25 | 権限制御がロールベースで行われる | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 権限制御の詳細設定（どのロールがどの操作を実行できるか）
  - 候補：Policy定義 / Gate定義 / Filament Shield設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分の主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 権限制御の実装有無を確認
- [ ] 通知メッセージの多言語対応を確認
- [ ] フィルタ条件の網羅性を確認
