---
generated_at: 2025-12-26 18:52:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：352-休暇タイプ作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/Configurations/Resources/LeaveTypeResource.php`
- E-02: `plugins/webkul/time-off/src/Filament/Clusters/Configurations/Resources/LeaveTypeResource/Pages/CreateLeaveType.php`
- E-03: `plugins/webkul/time-off/src/Models/LeaveType.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別が作成画面である | E-02 (CreateRecord継承) | ○ |
| C-02 | URLが/time-off/configurations/leave-types/createである | E-01 (getPages()) | ○ |
| C-03 | nameフィールドが必須で最大255文字 | E-01 (form定義) | ○ |
| C-04 | leave_validation_typeのデフォルトがHR | E-01 (form定義) | ○ |
| C-05 | requires_allocationのデフォルトがNO | E-01 (form定義) | ○ |
| C-06 | employee_requestsが条件付き表示 | E-01 (visible fn) | ○ |
| C-07 | allocation_validation_typeが条件付き表示 | E-01 (visible fn) | ○ |
| C-08 | colorがColorPickerで必須 | E-01 (form定義) | ○ |
| C-09 | 通知担当者が複数選択可能 | E-01 (Select multiple) | ○ |
| C-10 | request_unitのデフォルトがDAY | E-01 (form定義) | ○ |
| C-11 | time_typeのデフォルトがLEAVE | E-01 (form定義) | ○ |
| C-12 | allows_negativeが条件付き表示 | E-01 (visible fn) | ○ |
| C-13 | max_allowed_negativeが条件付き表示 | E-01 (visible fn) | ○ |
| C-14 | 保存後に詳細画面にリダイレクト | E-02 (getRedirectUrl) | ○ |
| C-15 | 保存時にcompany_idを自動設定 | E-02 (mutateFormDataBeforeCreate) | ○ |
| C-16 | 保存時にcreator_idを自動設定 | E-02 (mutateFormDataBeforeCreate) | ○ |
| C-17 | 保存成功時に通知を表示 | E-02 (getCreatedNotification) | ○ |
| C-18 | 3カラムレイアウトを使用 | E-01 (columns(3)) | ○ |
| C-19 | サブナビゲーションを表示 | E-02 (getSubNavigation) | ○ |
| C-20 | テーブル名がtime_off_leave_typesである | E-03 ($table) | ○ |
| C-21 | 中間テーブル名がtime_off_user_leave_types | E-03 (belongsToMany) | ○ |
| C-22 | 画面番号が352である | E-04 (画面一覧.csv) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] フォームバリデーションルールの網羅性を確認
- [ ] 条件付き表示のロジックの正確性を確認
- [ ] 通知メッセージの多言語対応を確認
