---
generated_at: 2025-12-26 18:56:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：354-休暇タイプ詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/Configurations/Resources/LeaveTypeResource.php`
- E-02: `plugins/webkul/time-off/src/Filament/Clusters/Configurations/Resources/LeaveTypeResource/Pages/ViewLeaveType.php`
- E-03: `plugins/webkul/time-off/src/Models/LeaveType.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別が詳細画面である | E-02 (ViewRecord継承) | ○ |
| C-02 | URLが/{record}の形式である | E-01 (getPages()) | ○ |
| C-03 | ヘッダーにEditActionがある | E-02 (getHeaderActions) | ○ |
| C-04 | ヘッダーにDeleteActionがある | E-02 (getHeaderActions) | ○ |
| C-05 | 削除成功時に通知を表示 | E-02 (DeleteAction設定) | ○ |
| C-06 | 3カラムグリッドレイアウト | E-01 (Grid make 3) | ○ |
| C-07 | nameがTextEntryで大きいテキスト | E-01 (TextSize::Large) | ○ |
| C-08 | leave_validation_typeがバッジ表示 | E-01 (badge()) | ○ |
| C-09 | requires_allocationがバッジ表示 | E-01 (badge()) | ○ |
| C-10 | employee_requestsが条件付き表示 | E-01 (visible fn) | ○ |
| C-11 | allocation_validation_typeが条件付き表示 | E-01 (visible fn) | ○ |
| C-12 | colorがColorEntryで表示 | E-01 (ColorEntry) | ○ |
| C-13 | 通知担当者がリスト表示 | E-01 (listWithLineBreaks) | ○ |
| C-14 | request_unitがバッジ表示 | E-01 (badge()) | ○ |
| C-15 | boolean項目がIconEntry | E-01 (IconEntry boolean) | ○ |
| C-16 | allows_negativeが条件付き表示 | E-01 (visible fn) | ○ |
| C-17 | max_allowed_negativeが条件付き表示 | E-01 (visible fn) | ○ |
| C-18 | プレースホルダーに「—」を使用 | E-01 (placeholder('—')) | ○ |
| C-19 | サブナビゲーションを表示 | E-02 (getSubNavigation) | ○ |
| C-20 | 画面番号が354である | E-04 (画面一覧.csv) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 削除済みレコードへのアクセス時の挙動を確認
- [ ] 通知担当者がいない場合の表示を確認
- [ ] 条件付き表示の条件ロジックを確認
