---
generated_at: 2025-12-26 18:58:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：355-累積プラン一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/Configurations/Resources/AccrualPlanResource.php`
- E-02: `plugins/webkul/time-off/src/Filament/Clusters/Configurations/Resources/AccrualPlanResource/Pages/ListAccrualPlans.php`
- E-03: `plugins/webkul/time-off/src/Models/LeaveAccrualPlan.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別が一覧画面である | E-02 (ListRecords継承) | ○ |
| C-02 | URLが/time-off/configurations/accrual-plansである | E-01 (getPages()) | ○ |
| C-03 | 新規作成ボタンがヘッダーに存在する | E-02 (getHeaderActions()) | ○ |
| C-04 | nameカラムが検索可能 | E-01 (searchable()) | ○ |
| C-05 | レベル数をカウントして表示 | E-01 (formatStateUsing count) | ○ |
| C-06 | 行アクションにView/Edit/Deleteがある | E-01 (recordActions) | ○ |
| C-07 | 一括アクションにDeleteがある | E-01 (toolbarActions) | ○ |
| C-08 | 削除成功時に通知を表示 | E-01 (DeleteAction設定) | ○ |
| C-09 | テーブル名がtime_off_leave_accrual_plansである | E-03 ($table) | ○ |
| C-10 | leaveAccrualLevelsリレーションがある | E-03 (hasMany) | ○ |
| C-11 | ソフトデリートは使用していない | E-03 (SoftDeletes未使用) | ○ |
| C-12 | 画面番号が355である | E-04 (画面一覧.csv) | ○ |
| C-13 | 機能IDがFN-TOFF-013である | E-05 (画面機能マッピング.csv) | ○ |
| C-14 | company_idとcreator_idが存在する | E-03 ($fillable) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 削除時の関連レコード（levels）の扱いを確認
- [ ] 検索機能の実際の動作を確認
- [ ] 通知メッセージの多言語対応を確認
