---
generated_at: 2025-12-26 19:00:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：356-累積プラン作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/Configurations/Resources/AccrualPlanResource.php`
- E-02: `plugins/webkul/time-off/src/Filament/Clusters/Configurations/Resources/AccrualPlanResource/Pages/CreateAccrualPlan.php`
- E-03: `plugins/webkul/time-off/src/Models/LeaveAccrualPlan.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別が作成画面である | E-02 (CreateRecord継承) | ○ |
| C-02 | URLが/create形式である | E-01 (getPages()) | ○ |
| C-03 | nameフィールドが必須 | E-01 (required()) | ○ |
| C-04 | is_based_on_worked_timeがトグル | E-01 (Toggle) | ○ |
| C-05 | accrued_gain_timeのデフォルトがEND | E-01 (default) | ○ |
| C-06 | carryover_dateのデフォルトがOTHER | E-01 (default) | ○ |
| C-07 | 繰越日付が条件付き表示 | E-01 (visible fn) | ○ |
| C-08 | carryover_dayが動的に日数を生成 | E-01 (options fn) | ○ |
| C-09 | carryover_monthがreactive | E-01 (reactive()) | ○ |
| C-10 | 保存後に詳細画面にリダイレクト | E-02 (getRedirectUrl) | ○ |
| C-11 | 保存時にcompany_idを自動設定 | E-02 (mutateFormDataBeforeCreate) | ○ |
| C-12 | 保存時にcreator_idを自動設定 | E-02 (mutateFormDataBeforeCreate) | ○ |
| C-13 | 保存成功時に通知を表示 | E-02 (getCreatedNotification) | ○ |
| C-14 | サブナビゲーション位置がStart | E-02 (getSubNavigationPosition) | ○ |
| C-15 | 2カラムレイアウト | E-01 (columns(2)) | ○ |
| C-16 | 画面番号が356である | E-04 (画面一覧.csv) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 繰越日の条件付き表示ロジックを確認
- [ ] 月に応じた日数生成の正確性を確認
- [ ] 通知メッセージの多言語対応を確認
