---
generated_at: 2025-12-26 19:02:00
metrics:
  claims_total: 16
  claims_with_evidence: 16
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：357-累積プラン編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：16 / 16、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/Configurations/Resources/AccrualPlanResource.php`
- E-02: `plugins/webkul/time-off/src/Filament/Clusters/Configurations/Resources/AccrualPlanResource/Pages/EditAccrualPlan.php`
- E-03: `plugins/webkul/time-off/src/Models/LeaveAccrualPlan.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別が編集画面である | E-02 (EditRecord継承) | ○ |
| C-02 | URLが/{record}/edit形式である | E-01 (getPages()) | ○ |
| C-03 | ヘッダーにViewActionがある | E-02 (getHeaderActions) | ○ |
| C-04 | ヘッダーにDeleteActionがある | E-02 (getHeaderActions) | ○ |
| C-05 | 保存後に詳細画面にリダイレクト | E-02 (getRedirectUrl) | ○ |
| C-06 | 保存時にcompany_idを自動設定 | E-02 (mutateFormDataBeforeSave) | ○ |
| C-07 | 保存時にcreator_idを自動設定 | E-02 (mutateFormDataBeforeSave) | ○ |
| C-08 | 保存成功時に通知を表示 | E-02 (getSavedNotification) | ○ |
| C-09 | 削除成功時に通知を表示 | E-02 (DeleteAction設定) | ○ |
| C-10 | HasRecordNavigationTabsトレイトを使用 | E-02 (use HasRecordNavigationTabs) | ○ |
| C-11 | 作成画面と同じフォームを使用 | E-01 (form()) | ○ |
| C-12 | nameフィールドが必須 | E-01 (required()) | ○ |
| C-13 | 条件付き表示フィールドがある | E-01 (visible fn) | ○ |
| C-14 | ライブ更新が有効 | E-01 (live()) | ○ |
| C-15 | レコードサブナビゲーションがある | E-01 (getRecordSubNavigation) | ○ |
| C-16 | 画面番号が357である | E-04 (画面一覧.csv) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 削除時の関連レコード（levels）の扱いを確認
- [ ] レコードサブナビゲーションの動作を確認
- [ ] 通知メッセージの多言語対応を確認
