---
generated_at: 2025-12-26 19:04:00
metrics:
  claims_total: 14
  claims_with_evidence: 14
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：358-累積プラン詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：14 / 14、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/Configurations/Resources/AccrualPlanResource.php`
- E-02: `plugins/webkul/time-off/src/Filament/Clusters/Configurations/Resources/AccrualPlanResource/Pages/ViewAccrualPlan.php`
- E-03: `plugins/webkul/time-off/src/Models/LeaveAccrualPlan.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別が詳細画面である | E-02 (ViewRecord継承) | ○ |
| C-02 | URLが/{record}形式である | E-01 (getPages()) | ○ |
| C-03 | ヘッダーにEditActionがある | E-02 (getHeaderActions) | ○ |
| C-04 | ヘッダーにDeleteActionがある | E-02 (getHeaderActions) | ○ |
| C-05 | 削除成功時に通知を表示 | E-02 (DeleteAction設定) | ○ |
| C-06 | 2カラムグリッドレイアウト | E-01 (Grid make 2) | ○ |
| C-07 | nameがTextEntryで表示 | E-01 (TextEntry) | ○ |
| C-08 | is_based_on_worked_timeがIconEntry | E-01 (IconEntry boolean) | ○ |
| C-09 | accrued_gain_timeがTextEntry | E-01 (TextEntry) | ○ |
| C-10 | carryover_dateがTextEntry | E-01 (TextEntry) | ○ |
| C-11 | プレースホルダーに「—」を使用 | E-01 (placeholder('—')) | ○ |
| C-12 | HasRecordNavigationTabsトレイトを使用 | E-02 (use HasRecordNavigationTabs) | ○ |
| C-13 | レコードサブナビゲーションがある | E-01 (getRecordSubNavigation) | ○ |
| C-14 | 画面番号が358である | E-04 (画面一覧.csv) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] レコードサブナビゲーションの動作を確認
- [ ] マイルストーン管理へのリンクを確認
- [ ] 削除時の関連レコード（levels）の扱いを確認
