---
generated_at: 2025-12-26 19:06:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：359-祝日一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/time-off/src/Filament/Clusters/Configurations/Resources/PublicHolidayResource.php`
- E-02: `plugins/webkul/time-off/src/Filament/Clusters/Configurations/Resources/PublicHolidayResource/Pages/ListPublicHolidays.php`
- E-03: `plugins/webkul/time-off/src/Models/CalendarLeave.php`
- E-04: `plugins/webkul/employees/src/Models/CalendarLeaves.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別が一覧+モーダル管理画面である | E-02 (ListRecords継承, CreateAction) | ○ |
| C-02 | URLが/public-holidaysである | E-01 (getPages()) | ○ |
| C-03 | 新規作成ボタンがモーダルフォームを表示 | E-02 (CreateAction::make()) | ○ |
| C-04 | nameフィールドが必須 | E-01 (form定義 required()) | ○ |
| C-05 | date_fromに今日以降の制約がある | E-01 (minDate, after_or_equal:today) | ○ |
| C-06 | date_toにdate_from以降の制約がある | E-01 (minDate, after_or_equal:date_from) | ○ |
| C-07 | calendarがsearchable, preload | E-01 (Select relationship) | ○ |
| C-08 | time_typeがhiddenで'leave'固定 | E-01 (Hidden default('leave')) | ○ |
| C-09 | nameカラムが検索・ソート可能 | E-01 (searchable(), sortable()) | ○ |
| C-10 | グループ化オプションがある | E-01 (groups配列) | ○ |
| C-11 | 会社フィルタがある | E-01 (SelectFilter company_id) | ○ |
| C-12 | 作成者フィルタがある | E-01 (SelectFilter creator_id) | ○ |
| C-13 | QueryBuilderフィルタがある | E-01 (QueryBuilder::make) | ○ |
| C-14 | 行アクションにView/Edit/Deleteがある | E-01 (recordActions) | ○ |
| C-15 | 編集成功時に通知を表示 | E-01 (EditAction successNotification) | ○ |
| C-16 | 削除成功時に通知を表示 | E-01 (DeleteAction successNotification) | ○ |
| C-17 | 一括削除がある | E-01 (DeleteBulkAction) | ○ |
| C-18 | 作成時にcompany_idを自動設定 | E-02 (mutateDataUsing) | ○ |
| C-19 | 作成時にcreator_idを自動設定 | E-02 (mutateDataUsing) | ○ |
| C-20 | テーブル名がemployees_calendar_leaves | E-04 ($table) | ○ |
| C-21 | CalendarLeaveがBaseCalendarLeaveを継承 | E-03 (extends BaseCalendarLeave) | ○ |
| C-22 | 画面番号が359である | E-05 (画面一覧.csv) | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから直接確認可能

## 6) レビュアーチェックリスト（最小）
- [ ] 日付バリデーションの動作を確認
- [ ] カレンダーとの関連付けの動作を確認
- [ ] グループ化機能の実際の動作を確認
- [ ] 通知メッセージの多言語対応を確認
