---
generated_at: 2025-12-26 12:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：361-タイムシート管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティング**：実際のルーティング設定ファイルでの確認が必要
  2. **多言語ラベル**：翻訳ファイルの内容確認が必要
  3. **権限制御**：詳細な権限設定の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/timesheets/src/Filament/Resources/TimesheetResource/Pages/ManageTimesheets.php`
- E-02: `plugins/webkul/timesheets/src/Filament/Resources/TimesheetResource.php`
- E-03: `plugins/webkul/projects/src/Models/Timesheet.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（No.361）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ManageRecordsページとして実装 | E-01 (extends ManageRecords) | ○ |
| C-02 | CreateActionがヘッダーに存在 | E-01 (getHeaderActions) | ○ |
| C-03 | creator_idが自動設定される | E-01 (mutateDataUsing) | ○ |
| C-04 | マイタイムシートプリセットビューが存在 | E-01 (getPresetTableViews) | ○ |
| C-05 | user_idでフィルタリング | E-01 (where user_id = Auth::id()) | ○ |
| C-06 | type='projects'が設定される | E-02 (Hidden::make('type')->default('projects')) | ○ |
| C-07 | 日付フィールドはDatePicker | E-02 (DatePicker::make('date')) | ○ |
| C-08 | 従業員はSelect+relationship | E-02 (Select::make('user_id')->relationship) | ○ |
| C-09 | プロジェクト選択でタスクがリセット | E-02 (afterStateUpdated set task_id null) | ○ |
| C-10 | タスクはプロジェクトでフィルタ | E-02 (modifyQueryUsing project_id) | ○ |
| C-11 | unit_amountは数値0〜99999999999 | E-02 (numeric minValue maxValue) | ○ |
| C-12 | 作業時間は時:分形式で表示 | E-02 (formatStateUsing) | ○ |
| C-13 | Sum集計が表示される | E-02 (summarize Sum::make()) | ○ |
| C-14 | 5つのグループ化オプション | E-02 (groups配列) | ○ |
| C-15 | 5つのフィルタオプション | E-02 (filters配列) | ○ |
| C-16 | EditAction/DeleteActionが行に存在 | E-02 (recordActions) | ○ |
| C-17 | DeleteBulkActionが存在 | E-02 (toolbarActions BulkActionGroup) | ○ |
| C-18 | Timesheetモデルはanalytics_recordsを使用 | E-03 (extends Record) | ○ |
| C-19 | 作成時にタスク時間が更新される | E-03 (static::created callback) | ○ |
| C-20 | 更新時にタスク時間が更新される | E-03 (static::updated callback) | ○ |
| C-21 | 削除時にタスク時間が更新される | E-03 (static::deleted callback) | ○ |
| C-22 | updateTaskTimesでprogress等を計算 | E-03 (updateTaskTimes method) | ○ |
| C-23 | 親タスクも更新される | E-03 (if parentTask) | ○ |
| C-24 | 画面No.361として登録 | E-04 | ○ |
| C-25 | URL /admin/timesheets | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- ルーティング設定ファイル（routes/web.php または routes/filament.php）の確認が必要
  - 候補：routes/*.php / FilamentServiceProvider
- 翻訳ファイル（timesheets::filament/resources/timesheet.*）の内容確認
  - 候補：plugins/webkul/timesheets/resources/lang/

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - モデル構造・ビジネスロジックは明確
- 1: 中リスク - URL/ルーティングの実装詳細は未確認
- 0: 低リスク - 自動時間更新ロジックはコードで確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 実際のアプリケーションでタイムシート管理画面にアクセスし、URL確認
- [ ] マイタイムシートタブの動作確認
- [ ] タイムシート作成時のタスク時間自動更新の動作確認
- [ ] 親タスクの時間更新が正しく行われるか確認
