---
generated_at: 2025-12-26 12:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：362-ページ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. **メッセージ内容**：翻訳ファイルの実際の内容確認が推奨
  2. **権限設定**：FilamentShieldの設定確認が推奨
  3. **パフォーマンス**：大量データ時の動作確認が推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/website/src/Filament/Admin/Resources/PageResource/Pages/ListPages.php`
- E-02: `plugins/webkul/website/src/Filament/Admin/Resources/PageResource.php`
- E-03: `plugins/webkul/website/src/Models/Page.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（No.362）
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ListRecordsページとして実装 | E-01 (extends ListRecords) | ○ |
| C-02 | HasTableViewsトレイトを使用 | E-01 (use HasTableViews) | ○ |
| C-03 | Archivedプリセットビューが存在 | E-01 (getPresetTableViews) | ○ |
| C-04 | onlyTrashedでフィルタ | E-01 (modifyQueryUsing onlyTrashed) | ○ |
| C-05 | CreateActionがヘッダーに存在 | E-01 (getHeaderActions) | ○ |
| C-06 | URL slug=website/pages | E-02 ($slug) | ○ |
| C-07 | 8つのテーブル列が定義 | E-02 (table columns配列) | ○ |
| C-08 | title列は検索・ソート可能 | E-02 (searchable sortable) | ○ |
| C-09 | is_publishedはIconColumn | E-02 (IconColumn::make is_published) | ○ |
| C-10 | creator.nameはデフォルト非表示 | E-02 (toggleable isToggledHiddenByDefault) | ○ |
| C-11 | is_publishedフィルタが存在 | E-02 (Filter::make is_published) | ○ |
| C-12 | creator_id SelectFilterが存在 | E-02 (SelectFilter creator_id) | ○ |
| C-13 | ActionGroupで行アクション | E-02 (recordActions ActionGroup) | ○ |
| C-14 | ViewAction/EditActionは削除済みで非表示 | E-02 (hidden fn trashed) | ○ |
| C-15 | RestoreAction/DeleteAction/ForceDeleteAction | E-02 (recordActions配列) | ○ |
| C-16 | 一括アクション3種 | E-02 (toolbarActions BulkActionGroup) | ○ |
| C-17 | reorderableColumns有効 | E-02 (table reorderableColumns) | ○ |
| C-18 | columnManagerColumns(2) | E-02 | ○ |
| C-19 | PageモデルはSoftDeletes使用 | E-03 (use SoftDeletes) | ○ |
| C-20 | テーブル名はwebsite_pages | E-03 ($table) | ○ |
| C-21 | creatorリレーション存在 | E-03 (creator BelongsTo) | ○ |
| C-22 | 画面No.362として登録 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 翻訳ファイル（website::filament/admin/resources/page.*）の内容確認
  - 候補：plugins/webkul/website/resources/lang/
- FilamentShield権限設定の確認
  - 候補：config/filament-shield.php

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テーブル構造・列定義は明確
- 0: 低リスク - ソフトデリート実装はLaravel標準
- 0: 低リスク - 行アクション・一括アクションは標準的なFilament実装

## 6) レビュアーチェックリスト（最小）
- [ ] 実際のアプリケーションでページ一覧画面にアクセス確認
- [ ] Archivedタブで削除済みページが表示されることを確認
- [ ] 復元・完全削除の動作確認
- [ ] 列の並び替え・表示切替が正常に動作することを確認
