---
generated_at: 2025-12-26 12:15:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：364-ページ編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  1. **公開/下書き動作**：実際の状態変更動作の確認が推奨
  2. **リダイレクト先**：保存後・削除後のリダイレクト先URLの確認
  3. **通知メッセージ**：翻訳ファイルの実際の内容確認が推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/website/src/Filament/Admin/Resources/PageResource/Pages/EditPage.php`
- E-02: `plugins/webkul/website/src/Filament/Admin/Resources/PageResource.php`
- E-03: `plugins/webkul/website/src/Models/Page.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（No.364）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | EditRecordページとして実装 | E-01 (extends EditRecord) | ○ |
| C-02 | 保存後view画面にリダイレクト | E-01 (getRedirectUrl -> getUrl view) | ○ |
| C-03 | 保存成功時に通知表示 | E-01 (getSavedNotification) | ○ |
| C-04 | publishアクションが存在 | E-01 (Action::make publish) | ○ |
| C-05 | 公開時にis_published=true設定 | E-01 (update is_published true) | ○ |
| C-06 | 公開時にpublished_at=now()設定 | E-01 (update published_at now()) | ○ |
| C-07 | publishは!is_publishedで表示 | E-01 (visible fn !is_published) | ○ |
| C-08 | draftアクションが存在 | E-01 (Action::make draft) | ○ |
| C-09 | 下書き時にis_published=false設定 | E-01 (update is_published false) | ○ |
| C-10 | 下書き時にpublished_at=null設定 | E-01 (update published_at null) | ○ |
| C-11 | draftはis_publishedで表示 | E-01 (visible fn is_published) | ○ |
| C-12 | DeleteActionが存在 | E-01 (DeleteAction::make) | ○ |
| C-13 | サブナビゲーションはTop配置 | E-02 (SubNavigationPosition::Top) | ○ |
| C-14 | サブナビにViewPage/EditPage | E-02 (getRecordSubNavigation) | ○ |
| C-15 | タイトルは必須入力 | E-02 (TextInput title required) | ○ |
| C-16 | スラッグは無効化 | E-02 (TextInput slug disabled) | ○ |
| C-17 | コンテンツはRichEditor | E-02 (RichEditor content required) | ○ |
| C-18 | SEOセクションが存在 | E-02 (Section seo.title) | ○ |
| C-19 | Toggle設定項目 | E-02 (Toggle is_header_visible is_footer_visible) | ○ |
| C-20 | 画面No.364として登録 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 翻訳ファイル（website::filament/admin/resources/page/pages/edit-record.*）の内容確認
  - 候補：plugins/webkul/website/resources/lang/
- 削除後のリダイレクト先（デフォルトは一覧）の確認
  - 候補：Filament標準動作の確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 公開/下書きロジックはコードで明確
- 0: 低リスク - フォーム項目・バリデーションは明確
- 0: 低リスク - リダイレクト・通知処理は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 実際のアプリケーションでページ編集画面にアクセス確認
- [ ] 未公開ページで「公開」ボタンが表示されることを確認
- [ ] 公開済みページで「下書き」ボタンが表示されることを確認
- [ ] 公開/下書き切り替えでis_published/published_atが正しく更新されることを確認
- [ ] 削除後にページ一覧にリダイレクトされることを確認
