---
generated_at: 2025-12-26 12:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：365-ページ詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  1. **Markdown表示**：コンテンツのMarkdown変換表示の動作確認が推奨
  2. **アイコン表示**：各項目のアイコン表示の確認が推奨
  3. **プレースホルダー**：未設定値の「—」表示確認が推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/website/src/Filament/Admin/Resources/PageResource/Pages/ViewPage.php`
- E-02: `plugins/webkul/website/src/Filament/Admin/Resources/PageResource.php`
- E-03: `plugins/webkul/website/src/Models/Page.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（No.365）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ViewRecordページとして実装 | E-01 (extends ViewRecord) | ○ |
| C-02 | DeleteActionがヘッダーに存在 | E-01 (getHeaderActions DeleteAction) | ○ |
| C-03 | 削除成功時に通知表示 | E-01 (successNotification) | ○ |
| C-04 | サブナビゲーションはTop配置 | E-02 (SubNavigationPosition::Top) | ○ |
| C-05 | サブナビにViewPage/EditPage | E-02 (getRecordSubNavigation) | ○ |
| C-06 | infolistスキーマが定義 | E-02 (infolist method) | ○ |
| C-07 | タイトルはLarge/Bold表示 | E-02 (TextEntry title size weight) | ○ |
| C-08 | コンテンツはMarkdown表示 | E-02 (TextEntry content markdown) | ○ |
| C-09 | SEOセクションが存在 | E-02 (Section seo.title) | ○ |
| C-10 | meta_titleにドキュメントアイコン | E-02 (TextEntry meta_title icon document-text) | ○ |
| C-11 | meta_keywordsにハッシュタグアイコン | E-02 (TextEntry meta_keywords icon hashtag) | ○ |
| C-12 | レコード情報セクションが存在 | E-02 (Section record-information) | ○ |
| C-13 | creator.nameにユーザーアイコン | E-02 (TextEntry creator.name icon user) | ○ |
| C-14 | published_at/created_at/updated_atにカレンダーアイコン | E-02 (TextEntry dateTime icon calendar) | ○ |
| C-15 | is_publishedはIconEntry Boolean | E-02 (IconEntry is_published boolean) | ○ |
| C-16 | 設定セクションが存在 | E-02 (Section settings) | ○ |
| C-17 | is_header_visible/is_footer_visibleはIconEntry | E-02 (IconEntry boolean) | ○ |
| C-18 | 画面No.365として登録 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 翻訳ファイル（website::filament/admin/resources/page.*）の内容確認
  - 候補：plugins/webkul/website/resources/lang/
- プレースホルダー「—」の表示確認
  - 候補：実アプリケーションでの動作確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - Infolist構造は明確
- 0: 低リスク - 表示項目・スタイリングはコードで確認済み
- 0: 低リスク - サブナビゲーション構成は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 実際のアプリケーションでページ詳細画面にアクセス確認
- [ ] タイトルがLarge/Bold表示されることを確認
- [ ] コンテンツがMarkdownレンダリングされることを確認
- [ ] 各項目にアイコンが表示されることを確認
- [ ] 未設定項目に「—」が表示されることを確認
- [ ] サブナビゲーションから編集画面に遷移できることを確認
