---
generated_at: 2025-12-26 12:25:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：366-パートナー一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  1. **カード表示レイアウト**：実際のレスポンシブ動作確認が推奨
  2. **QueryBuilderフィルタ**：全フィルタの動作確認が推奨
  3. **外部キー制約エラー**：完全削除時のエラーハンドリング確認が推奨

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/website/src/Filament/Admin/Resources/PartnerResource/Pages/ListPartners.php`
- E-02: `plugins/webkul/website/src/Filament/Admin/Resources/PartnerResource.php`
- E-03: `plugins/webkul/partners/src/Filament/Resources/PartnerResource.php`（ベースリソース）
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`（No.366）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | BaseListPartnersを継承 | E-01 (extends BaseListPartners) | ○ |
| C-02 | URL slug=website/contacts | E-02 ($slug) | ○ |
| C-03 | ナビゲーション表示有効 | E-02 (shouldRegisterNavigation = true) | ○ |
| C-04 | サブナビゲーションはTop配置 | E-02 (SubNavigationPosition::Top) | ○ |
| C-05 | サブナビにView/Edit/Contacts/Addresses | E-02 (getRecordSubNavigation) | ○ |
| C-06 | カードグリッドレスポンシブ設定 | E-03 (contentGrid) | ○ |
| C-07 | ページネーション設定 | E-03 (paginated 16, 32, 64, all) | ○ |
| C-08 | Stack列レイアウト | E-03 (Stack::make columns) | ○ |
| C-09 | ImageColumn avatar | E-03 (ImageColumn avatar height width) | ○ |
| C-10 | 名前はBold表示 | E-03 (TextColumn name weight Bold) | ○ |
| C-11 | 条件付き表示 | E-03 (visible fn filled) | ○ |
| C-12 | タグバッジ表示 | E-03 (tags.name badge color) | ○ |
| C-13 | 5つのグループ化オプション | E-03 (groups配列) | ○ |
| C-14 | QueryBuilderフィルタ | E-03 (QueryBuilder::make constraints) | ○ |
| C-15 | フィルタはモーダル | E-03 (layout FiltersLayout::Modal slideOver) | ○ |
| C-16 | account_type!=address除外 | E-03 (modifyQueryUsing where !=) | ○ |
| C-17 | ViewAction/EditActionは削除済みで非表示 | E-03 (hidden fn trashed) | ○ |
| C-18 | ForceDeleteActionのエラーハンドリング | E-03 (QueryException catch) | ○ |
| C-19 | 一括アクション3種 | E-03 (toolbarActions BulkActionGroup) | ○ |
| C-20 | Infolistで詳細表示定義 | E-03 (infolist method) | ○ |
| C-21 | RelationGroupでContacts/Addresses | E-02 (getRelations) | ○ |
| C-22 | 画面No.366として登録 | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- 翻訳ファイル（website::filament/admin/resources/partner.*）の内容確認
  - 候補：plugins/webkul/website/resources/lang/
- Partnerモデルの詳細構造確認
  - 候補：plugins/webkul/partners/src/Models/Partner.php

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 継承関係は明確
- 0: 低リスク - カードグリッド構造はコードで確認済み
- 0: 低リスク - フィルタ・アクションは標準的なFilament実装

## 6) レビュアーチェックリスト（最小）
- [ ] 実際のアプリケーションでパートナー一覧画面にアクセス確認
- [ ] カードグリッドがレスポンシブに表示されることを確認
- [ ] QueryBuilderフィルタが正常に動作することを確認
- [ ] タグがカラーバッジとして表示されることを確認
- [ ] 完全削除時の外部キー制約エラーハンドリングを確認
- [ ] サブナビゲーションから関連ページに遷移できることを確認
