---
generated_at: 2025-12-26 18:30:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：37-支払期限管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/accounts/src/Filament/Resources/PaymentTermResource/Pages/ManagePaymentDueTerm.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/PaymentTermResource.php`
- E-03: `plugins/webkul/accounts/src/Traits/PaymentDueTerm.php`
- E-04: `plugins/webkul/accounts/src/Models/PaymentDueTerm.php`
- E-05: `plugins/webkul/accounts/src/Models/PaymentTerm.php`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「支払期限管理」 | E-06 | ○ |
| C-02 | URLパターンは `/payment-terms/{record}/payment-due-terms` | E-02 (getPages) | ○ |
| C-03 | ManageRelatedRecordsを継承 | E-01 | ○ |
| C-04 | PaymentDueTermトレイトを使用 | E-01 (use PaymentDueTerm) | ○ |
| C-05 | リレーションシップは`dueTerm` | E-01 ($relationship) | ○ |
| C-06 | サブナビゲーションが上部に配置 | E-01 (getSubNavigationPosition) | ○ |
| C-07 | ナビゲーションアイコンはbanknotes | E-01 ($navigationIcon) | ○ |
| C-08 | フォームにvalueフィールドがある | E-03 (form) | ○ |
| C-09 | value_amountのデフォルトは100 | E-03 (default(100)) | ○ |
| C-10 | delay_typeフィールドが必須 | E-03 (required) | ○ |
| C-11 | days_next_monthのデフォルトは10 | E-03 (default(10)) | ○ |
| C-12 | nb_daysのデフォルトは0 | E-03 (default(0)) | ○ |
| C-13 | テーブルにvalue_amountカラムがある | E-03 (table) | ○ |
| C-14 | テーブルにvalueカラムがある（列挙型変換） | E-03 (formatStateUsing) | ○ |
| C-15 | テーブルにdelay_typeカラムがある（列挙型変換） | E-03 (formatStateUsing) | ○ |
| C-16 | ViewAction, EditAction, DeleteActionがある | E-03 (recordActions) | ○ |
| C-17 | CreateActionがheaderActionsにある | E-03 (headerActions) | ○ |
| C-18 | 新規作成ボタンにplus-circleアイコン | E-03 (icon) | ○ |
| C-19 | テーブル名はaccounts_payment_due_terms | E-04 ($table) | ○ |
| C-20 | paymentTermリレーションがある | E-04 (belongsTo) | ○ |
| C-21 | 多言語通知メッセージを使用 | E-03 (言語キー使用) | ○ |
| C-22 | PaymentTerm作成時に自動でDueTermが作成される | E-05 (boot, created) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - フォーム構造と入力項目
- 0: 低リスク - テーブル構造
- 0: 低リスク - CRUD操作

## 6) レビュアーチェックリスト（最小）
- [ ] DueTermValue列挙型のオプションを確認
- [ ] DelayType列挙型のオプションを確認
- [ ] 多言語ファイルの通知メッセージ内容を確認
- [ ] 自動作成されるデフォルトの支払期限の動作を確認
