---
generated_at: 2025-12-26 18:45:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：38-支払一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - 全ての主張に根拠があります

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/accounts/src/Filament/Resources/PaymentsResource.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/PaymentsResource/Pages/ListPayments.php`
- E-03: `plugins/webkul/accounts/src/Models/Payment.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `plugins/webkul/accounts/src/Enums/PaymentStatus.php`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「支払一覧」 | E-04 | ○ |
| C-02 | URLパターンは `/payments` | E-01 (getPages) | ○ |
| C-03 | ListRecordsを継承 | E-02 | ○ |
| C-04 | HasTableViewsトレイトを使用 | E-02 (use HasTableViews) | ○ |
| C-05 | ナビゲーション非登録 | E-01 ($shouldRegisterNavigation) | ○ |
| C-06 | テーブルにnameカラムがある | E-01 (table) | ○ |
| C-07 | テーブルにcompany.nameカラムがある | E-01 (table) | ○ |
| C-08 | テーブルにpartnerBank.account_holder_nameカラムがある | E-01 (table) | ○ |
| C-09 | プリセットビューにcustomer_paymentsがある | E-02 (getPresetTableViews) | ○ |
| C-10 | プリセットビューにvendor_paymentsがある | E-02 (getPresetTableViews) | ○ |
| C-11 | プリセットビューにdraftがある（デフォルト） | E-02 (setAsDefault) | ○ |
| C-12 | プリセットビューにin_processがある | E-02 (getPresetTableViews) | ○ |
| C-13 | プリセットビューにis_sentがある | E-02 (getPresetTableViews) | ○ |
| C-14 | プリセットビューにnot_sentがある | E-02 (getPresetTableViews) | ○ |
| C-15 | プリセットビューにno_bank_matchingがある | E-02 (getPresetTableViews) | ○ |
| C-16 | プリセットビューにis_reconciledがある | E-02 (getPresetTableViews) | ○ |
| C-17 | QueryBuilderフィルタがある | E-01 (filters) | ○ |
| C-18 | グルーピング機能がある | E-01 (groups) | ○ |
| C-19 | カラム並べ替え可能 | E-01 (reorderableColumns) | ○ |
| C-20 | DeleteBulkActionがある | E-01 (toolbarActions) | ○ |
| C-21 | ViewActionがある | E-01 (recordActions) | ○ |
| C-22 | EditActionがある | E-01 (recordActions) | ○ |
| C-23 | DeleteActionがある | E-01 (recordActions) | ○ |
| C-24 | ID降順でソート | E-01 (getEloquentQuery) | ○ |
| C-25 | テーブル名はaccounts_account_payments | E-03 ($table) | ○ |
| C-26 | CreateActionがヘッダーにある | E-02 (getHeaderActions) | ○ |

## 4) 不足情報（Unknown / Missing）
- 特になし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - テーブル構成
- 0: 低リスク - プリセットビュー
- 0: 低リスク - フィルタ機能

## 6) レビュアーチェックリスト（最小）
- [ ] プリセットビューのフィルタ条件が正しく動作するか実機確認
- [ ] 多言語ファイルのラベル内容を確認
- [ ] 一括削除の権限制御を確認
