---
generated_at: 2025-12-26 18:20:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：45-返金詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **アクションの詳細処理ロジック**：各BaseActionsの具体的処理
  2. **表示条件の詳細**：各アクションボタンのvisible条件

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/accounts/src/Filament/Resources/RefundResource/Pages/ViewRefund.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/RefundResource.php`
- E-03: `plugins/webkul/accounts/src/Filament/Resources/BillResource.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面クラス名は ViewRefund | E-01 L12 | ○ |
| C-02 | ViewRecord を継承 | E-01 L12 | ○ |
| C-03 | HasRecordNavigationTabs を使用 | E-01 L14 | ○ |
| C-04 | RefundResource を使用 | E-01 L16 | ○ |
| C-05 | ChatterAction を使用 | E-01 L20-21 | ○ |
| C-06 | PayAction を使用 | E-01 L22 | ○ |
| C-07 | CancelAction を使用 | E-01 L23 | ○ |
| C-08 | ConfirmAction を使用 | E-01 L24 | ○ |
| C-09 | ResetToDraftAction を使用 | E-01 L25 | ○ |
| C-10 | SetAsCheckedAction を使用 | E-01 L26 | ○ |
| C-11 | DeleteAction を使用 | E-01 L27 | ○ |
| C-12 | URLパターンは /refunds/{record} | E-02 L26 | ○ |
| C-13 | infolist は BillResource を継承 | E-03 L275-482 | ○ |
| C-14 | 支払状態バッジを表示 | E-03 L279-284 | ○ |
| C-15 | RepeatableEntry で明細を表示 | E-03 L343-407 | ○ |
| C-16 | InvoiceSummary コンポーネントを使用 | E-03 L408-419 | ○ |
| C-17 | 各アクションの表示条件詳細 | **根拠なし（BaseActions参照必要）** | △ |
| C-18 | 削除時の制約条件詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- BaseActions（InvoiceResource/Actions）のvisible条件定義
  - 候補：`plugins/webkul/accounts/src/Filament/Resources/InvoiceResource/Actions/`
- 削除可否の判定ロジック
  - 候補：DeleteActionのaction定義またはポリシークラス

## 5) リスクフラグ（レビュー観点）
- 1: 中リスク - アクション表示条件の詳細が未確認
- 0: 低リスク - 基本的な詳細表示は確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 各アクションボタンの表示条件がビジネス要件と一致するか確認
- [ ] 支払状態バッジの表示が正しいか確認
- [ ] 明細テーブルの表示項目が正しいか確認
- [ ] InvoiceSummaryの計算結果が正しいか確認
