---
generated_at: 2025-12-26 18:25:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：46-税一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **外部キー制約の詳細**：どのテーブルが参照しているか

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/accounts/src/Filament/Resources/TaxResource/Pages/ListTaxes.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/TaxResource.php`
- E-03: `plugins/webkul/accounts/src/Models/Tax.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面クラス名は ListTaxes | E-01 L14 | ○ |
| C-02 | HasTableViews トレイトを使用 | E-01 L16 | ○ |
| C-03 | TaxResource を使用 | E-01 L18 | ○ |
| C-04 | CreateAction を使用 | E-01 L22-24 | ○ |
| C-05 | 6つのプリセットビューを定義 | E-01 L28-61 | ○ |
| C-06 | 売上ビュー（type_tax_use = SALE） | E-01 L31-35 | ○ |
| C-07 | 仕入ビュー（type_tax_use = PURCHASE） | E-01 L36-40 | ○ |
| C-08 | 税スコープビュー（tax_scope = SERVICE） | E-01 L41-45 | ○ |
| C-09 | 商品ビュー（tax_scope = CONSU） | E-01 L46-50 | ○ |
| C-10 | アクティブビュー（is_active = true） | E-01 L51-55 | ○ |
| C-11 | 非アクティブビュー（is_active = false） | E-01 L56-60 | ○ |
| C-12 | テーブルカラム定義（name, company等） | E-02 L125-185 | ○ |
| C-13 | グループ化機能を提供 | E-02 L186-211 | ○ |
| C-14 | ActionGroup で行アクションをまとめる | E-02 L212-234 | ○ |
| C-15 | 削除時のQueryException処理 | E-02 L217-226 | ○ |
| C-16 | 一括削除でQueryException処理 | E-02 L238-249 | ○ |
| C-17 | reorderable('sort', 'desc')で並び替え | E-02 L258 | ○ |
| C-18 | SortableTrait をモデルで使用 | E-03 L18 | ○ |
| C-19 | sortカラムを使用 | E-03 L45-48 | ○ |
| C-20 | URLパターンは /taxes | E-02 L340 | ○ |
| C-21 | shouldRegisterNavigation = false | E-02 L48 | ○ |
| C-22 | 外部キー制約の参照元テーブル詳細 | **根拠なし（マイグレーション参照必要）** | △ |

## 4) 不足情報（Unknown / Missing）
- 外部キー制約の参照元テーブル一覧
  - 候補：マイグレーションファイル / データベーススキーマ
  - 想定される参照元：accounts_move_lines, products等

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本機能は詳細に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] プリセットビューのフィルタ条件が正しく動作するか確認
- [ ] 外部キー制約によるエラーハンドリングが適切か確認
- [ ] 並び替え機能が正しく動作するか確認
- [ ] カラムのトグル表示/非表示が適切か確認
