---
generated_at: 2025-12-26 18:45:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：50-税グループ一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **外部キー制約の参照元詳細**（Taxモデル以外の参照）

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/accounts/src/Filament/Resources/TaxGroupResource/Pages/ListTaxGroups.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/TaxGroupResource.php`
- E-03: `plugins/webkul/accounts/src/Models/TaxGroup.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面クラス名は ListTaxGroups | E-01 L9 | ○ |
| C-02 | TaxGroupResource を使用 | E-01 L11 | ○ |
| C-03 | CreateAction を使用 | E-01 L15-17 | ○ |
| C-04 | テーブルカラム定義（company, country等） | E-02 L67-92 | ○ |
| C-05 | グループ化機能を提供（6種類） | E-02 L94-113 | ○ |
| C-06 | ViewAction, EditAction を使用 | E-02 L115-116 | ○ |
| C-07 | DeleteAction を使用 | E-02 L117-133 | ○ |
| C-08 | 削除時のQueryException処理 | E-02 L118-128 | ○ |
| C-09 | 一括削除でQueryException処理 | E-02 L137-151 | ○ |
| C-10 | 一括削除でaction内でsuccess()を呼び出し | E-02 L142 | ○ |
| C-11 | URLパターンは /tax-groups | E-02 L193 | ○ |
| C-12 | shouldRegisterNavigation = false | E-02 L35 | ○ |
| C-13 | モデルは TaxGroup | E-02 L31 | ○ |
| C-14 | SortableTrait をモデルで使用 | E-03 L15 | ○ |
| C-15 | sortカラムを使用 | E-03 L28-31 | ○ |
| C-16 | created_at, updated_at はデフォルト非表示 | E-02 L83-92 | ○ |
| C-17 | Taxモデルから参照される | E-03参照、Tax.php L55-57 | ○ |
| C-18 | 外部キー制約の参照元テーブル詳細（Tax以外） | **根拠なし（マイグレーション参照必要）** | △ |

## 4) 不足情報（Unknown / Missing）
- 外部キー制約の参照元テーブル一覧（Tax以外）
  - 候補：マイグレーションファイル / データベーススキーマ

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本機能は詳細に確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 外部キー制約によるエラーハンドリングが適切か確認
- [ ] グループ化機能が正しく動作するか確認
- [ ] 新規作成ボタンのアイコンが正しく表示されるか確認
- [ ] 一括削除時のsuccess()呼び出しが適切か確認
