---
generated_at: 2025-12-26 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 17
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：51-税グループ作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：17 / 18、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細仕様**：具体的な権限チェックロジックの根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/accounts/src/Filament/Resources/TaxGroupResource/Pages/CreateTaxGroup.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/TaxGroupResource.php`
- E-03: `plugins/webkul/accounts/src/Models/TaxGroup.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別は登録画面 | E-01（CreateRecord継承） | ○ |
| C-02 | URLパスは/admin/accounts/tax-groups/create | E-02（route定義） | ○ |
| C-03 | company_idフィールドが存在 | E-02, E-03 | ○ |
| C-04 | country_idフィールドが存在 | E-02, E-03 | ○ |
| C-05 | nameフィールドは必須 | E-02（required()メソッド） | ○ |
| C-06 | nameフィールドの最大長は255 | E-02（maxLength(255)） | ○ |
| C-07 | preceding_subtotalフィールドが存在 | E-02, E-03 | ○ |
| C-08 | 保存後はView画面にリダイレクト | E-01（getRedirectUrl） | ○ |
| C-09 | 成功通知が表示される | E-01（getCreatedNotification） | ○ |
| C-10 | テーブル名はaccounts_tax_groups | E-03 | ○ |
| C-11 | creator_idが自動設定される | E-03（fillable配列） | ○ |
| C-12 | ソート順が自動管理される | E-03（SortableTrait） | ○ |
| C-13 | 会社選択はrelationship | E-02（Select::relationship） | ○ |
| C-14 | 国選択はrelationship | E-02（Select::relationship） | ○ |
| C-15 | 2カラムレイアウト | E-02（columns(2)） | ○ |
| C-16 | 関連機能はFN-ACC-022 | E-05 | ○ |
| C-17 | 画面No.51 | E-04 | ○ |
| C-18 | 権限制御が存在する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 権限制御の具体的な実装詳細（ポリシークラス、ミドルウェア等）
  - 候補：`AuthServiceProvider.php` / `TaxGroupPolicy.php` / Filament権限設定

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な画面仕様は十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 権限制御の実装を確認
- [ ] 多言語対応のラベル設定を確認
- [ ] 作成者IDの自動設定ロジックを確認
