---
generated_at: 2025-12-26 12:00:00
metrics:
  claims_total: 20
  claims_with_evidence: 19
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：52-税グループ編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：19 / 20、根拠なし：1
- 優先レビュー（高）
  1. **権限制御の詳細仕様**：削除権限の具体的なチェックロジックの根拠不足

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/accounts/src/Filament/Resources/TaxGroupResource/Pages/EditTaxGroup.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/TaxGroupResource.php`
- E-03: `plugins/webkul/accounts/src/Models/TaxGroup.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別は編集画面 | E-01（EditRecord継承） | ○ |
| C-02 | URLパスは/{record}/edit | E-02（route定義） | ○ |
| C-03 | ヘッダーにViewActionが存在 | E-01（getHeaderActions） | ○ |
| C-04 | ヘッダーにDeleteActionが存在 | E-01（getHeaderActions） | ○ |
| C-05 | 保存後はView画面にリダイレクト | E-01（getRedirectUrl） | ○ |
| C-06 | 保存成功通知が表示される | E-01（getSavedNotification） | ○ |
| C-07 | 削除成功通知が表示される | E-01（successNotification） | ○ |
| C-08 | 削除時にQueryExceptionをキャッチ | E-01（try-catch） | ○ |
| C-09 | 削除エラー時に通知表示 | E-01（Notification::danger） | ○ |
| C-10 | nameフィールドは必須 | E-02（required()） | ○ |
| C-11 | nameフィールドの最大長は255 | E-02（maxLength(255)） | ○ |
| C-12 | company_idフィールドが存在 | E-02, E-03 | ○ |
| C-13 | country_idフィールドが存在 | E-02, E-03 | ○ |
| C-14 | preceding_subtotalフィールドが存在 | E-02, E-03 | ○ |
| C-15 | テーブル名はaccounts_tax_groups | E-03 | ○ |
| C-16 | 2カラムレイアウト | E-02（columns(2)） | ○ |
| C-17 | 関連機能はFN-ACC-022 | E-05 | ○ |
| C-18 | 画面No.52 | E-04 | ○ |
| C-19 | TaxGroupモデルを使用 | E-01, E-03 | ○ |
| C-20 | 削除権限の制御が存在する | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 削除権限の具体的な実装詳細
  - 候補：`TaxGroupPolicy.php` / Filament権限設定 / Gate定義

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的な画面仕様は十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 削除権限の制御を確認
- [ ] 外部キー制約エラー時のユーザー体験を確認
- [ ] 多言語対応のラベル設定を確認
