---
generated_at: 2025-12-26 12:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：53-税グループ詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/accounts/src/Filament/Resources/TaxGroupResource/Pages/ViewTaxGroup.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/TaxGroupResource.php`
- E-03: `plugins/webkul/accounts/src/Models/TaxGroup.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別は詳細画面 | E-01（ViewRecord継承） | ○ |
| C-02 | URLパスは/{record} | E-02（route定義） | ○ |
| C-03 | ヘッダーにEditActionが存在 | E-01（getHeaderActions） | ○ |
| C-04 | ヘッダーにDeleteActionが存在 | E-01（getHeaderActions） | ○ |
| C-05 | 削除成功通知が表示される | E-01（successNotification） | ○ |
| C-06 | 削除時にQueryExceptionをキャッチ | E-01（try-catch） | ○ |
| C-07 | 削除エラー時に通知表示 | E-01（Notification::danger） | ○ |
| C-08 | company.nameが表示される | E-02（infolist） | ○ |
| C-09 | country.nameが表示される | E-02（infolist） | ○ |
| C-10 | nameが表示される | E-02（infolist） | ○ |
| C-11 | preceding_subtotalが表示される | E-02（infolist） | ○ |
| C-12 | 各項目にアイコンが設定 | E-02（icon()メソッド） | ○ |
| C-13 | 空値時にプレースホルダー表示 | E-02（placeholder('-')） | ○ |
| C-14 | テーブル名はaccounts_tax_groups | E-03 | ○ |
| C-15 | 2カラムレイアウト | E-02（columns(2)） | ○ |
| C-16 | 関連機能はFN-ACC-022 | E-05 | ○ |
| C-17 | 画面No.53 | E-04 | ○ |
| C-18 | TaxGroupモデルを使用 | E-01, E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 表示レイアウトの確認
- [ ] アイコン表示の確認
- [ ] 多言語対応のラベル設定を確認
