---
generated_at: 2025-12-26 12:00:00
metrics:
  claims_total: 28
  claims_with_evidence: 28
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：54-投稿一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：28 / 28、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/blogs/src/Filament/Admin/Resources/PostResource/Pages/ListPosts.php`
- E-02: `plugins/webkul/blogs/src/Filament/Admin/Resources/PostResource.php`
- E-03: `plugins/webkul/blogs/src/Models/Post.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`
- E-06: `docs/code-to-docs/画面一覧/画面遷移図.md`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別は一覧画面 | E-01（ListRecords継承） | ○ |
| C-02 | URLパスは/admin/website/posts | E-02（$slug定義） | ○ |
| C-03 | ヘッダーにCreateActionが存在 | E-01（getHeaderActions） | ○ |
| C-04 | HasTableViewsトレイトを使用 | E-01（use HasTableViews） | ○ |
| C-05 | 「自分の投稿」プリセットビュー存在 | E-01（my_posts） | ○ |
| C-06 | 「アーカイブ」プリセットビュー存在 | E-01（archived） | ○ |
| C-07 | 自分の投稿はauthor_idでフィルタ | E-01（where author_id） | ○ |
| C-08 | アーカイブはonlyTrashed | E-01（onlyTrashed()） | ○ |
| C-09 | titleカラムが存在 | E-02（TextColumn::make('title')） | ○ |
| C-10 | slugカラムが存在 | E-02（TextColumn::make('slug')） | ○ |
| C-11 | author.nameカラムが存在 | E-02（TextColumn::make('author.name')） | ○ |
| C-12 | is_publishedカラムが存在 | E-02（IconColumn::make('is_published')） | ○ |
| C-13 | created_atカラムが存在 | E-02（TextColumn::make('created_at')） | ○ |
| C-14 | is_publishedフィルターが存在 | E-02（Filter::make('is_published')） | ○ |
| C-15 | author_idフィルターが存在 | E-02（SelectFilter author_id） | ○ |
| C-16 | category_idフィルターが存在 | E-02（SelectFilter category_id） | ○ |
| C-17 | tagsフィルターが存在 | E-02（SelectFilter tags） | ○ |
| C-18 | カテゴリでグループ化可能 | E-02（Group category.name） | ○ |
| C-19 | ViewAction存在 | E-02（ViewAction::make()） | ○ |
| C-20 | EditAction存在 | E-02（EditAction::make()） | ○ |
| C-21 | DeleteAction存在 | E-02（DeleteAction::make()） | ○ |
| C-22 | RestoreAction存在 | E-02（RestoreAction::make()） | ○ |
| C-23 | ForceDeleteAction存在 | E-02（ForceDeleteAction::make()） | ○ |
| C-24 | DeleteBulkAction存在 | E-02（DeleteBulkAction::make()） | ○ |
| C-25 | RestoreBulkAction存在 | E-02（RestoreBulkAction::make()） | ○ |
| C-26 | ForceDeleteBulkAction存在 | E-02（ForceDeleteBulkAction::make()） | ○ |
| C-27 | テーブル名はblogs_posts | E-03 | ○ |
| C-28 | SoftDeletesを使用 | E-03（use SoftDeletes） | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] プリセットビューの動作確認
- [ ] フィルター・検索機能の確認
- [ ] ソフトデリート/復元機能の確認
- [ ] 多言語対応のラベル設定を確認
