---
generated_at: 2025-12-26 12:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：56-投稿編集

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/blogs/src/Filament/Admin/Resources/PostResource/Pages/EditPost.php`
- E-02: `plugins/webkul/blogs/src/Filament/Admin/Resources/PostResource.php`
- E-03: `plugins/webkul/blogs/src/Models/Post.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別は編集画面 | E-01（EditRecord継承） | ○ |
| C-02 | URLパスは/{record}/edit | E-02（route定義） | ○ |
| C-03 | 保存後はView画面にリダイレクト | E-01（getRedirectUrl） | ○ |
| C-04 | 保存成功通知が表示される | E-01（getSavedNotification） | ○ |
| C-05 | last_editor_idが自動設定される | E-01（mutateFormDataBeforeSave） | ○ |
| C-06 | 公開ボタンが存在 | E-01（Action::make('publish')） | ○ |
| C-07 | 下書きボタンが存在 | E-01（Action::make('draft')） | ○ |
| C-08 | 削除ボタンが存在 | E-01（DeleteAction::make()） | ○ |
| C-09 | 公開ボタンは未公開時のみ表示 | E-01（visible !is_published） | ○ |
| C-10 | 下書きボタンは公開時のみ表示 | E-01（visible is_published） | ○ |
| C-11 | 公開時にis_publishedをtrueに設定 | E-01（is_published => true） | ○ |
| C-12 | 公開時にpublished_atを設定 | E-01（published_at => now()） | ○ |
| C-13 | 下書き時にis_publishedをfalseに設定 | E-01（is_published => false） | ○ |
| C-14 | サブナビゲーションが存在 | E-02（SubNavigationPosition::Top） | ○ |
| C-15 | View/Editのサブナビゲーション | E-02（getRecordSubNavigation） | ○ |
| C-16 | titleフィールドは必須 | E-02（required()） | ○ |
| C-17 | contentフィールドは必須 | E-02（required()） | ○ |
| C-18 | slugは読み取り専用 | E-02（disabled()） | ○ |
| C-19 | 3カラムレイアウト | E-02（columns(3)） | ○ |
| C-20 | テーブル名はblogs_posts | E-03 | ○ |
| C-21 | SoftDeletesを使用 | E-03（use SoftDeletes） | ○ |
| C-22 | 削除成功通知が表示される | E-01（successNotification） | ○ |
| C-23 | 公開成功通知が表示される | E-01（Notification publish） | ○ |
| C-24 | 下書き成功通知が表示される | E-01（Notification draft） | ○ |
| C-25 | 関連機能はFN-BLOG-003 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 公開/下書き切替機能の確認
- [ ] サブナビゲーションの動作確認
- [ ] 最終編集者の記録確認
- [ ] ソフトデリート機能の確認
