---
generated_at: 2025-12-26 12:00:00
metrics:
  claims_total: 24
  claims_with_evidence: 24
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：57-投稿詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：24 / 24、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/blogs/src/Filament/Admin/Resources/PostResource/Pages/ViewPost.php`
- E-02: `plugins/webkul/blogs/src/Filament/Admin/Resources/PostResource.php`
- E-03: `plugins/webkul/blogs/src/Models/Post.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別は詳細画面 | E-01（ViewRecord継承） | ○ |
| C-02 | URLパスは/{record} | E-02（route定義） | ○ |
| C-03 | ヘッダーにDeleteActionが存在 | E-01（getHeaderActions） | ○ |
| C-04 | 削除成功通知が表示される | E-01（successNotification） | ○ |
| C-05 | titleがInfolistで表示 | E-02（TextEntry title） | ○ |
| C-06 | titleはLargeサイズ | E-02（TextSize::Large） | ○ |
| C-07 | titleはBold weight | E-02（FontWeight::Bold） | ○ |
| C-08 | contentがmarkdown形式 | E-02（markdown()） | ○ |
| C-09 | imageがImageEntry | E-02（ImageEntry::make） | ○ |
| C-10 | meta_titleにアイコン設定 | E-02（icon document-text） | ○ |
| C-11 | meta_keywordsにアイコン設定 | E-02（icon hashtag） | ○ |
| C-12 | author.nameにアイコン設定 | E-02（icon user） | ○ |
| C-13 | creator.nameにアイコン設定 | E-02（icon user） | ○ |
| C-14 | published_atが表示 | E-02（TextEntry published_at） | ○ |
| C-15 | created_atが表示 | E-02（TextEntry created_at） | ○ |
| C-16 | updated_atが表示 | E-02（TextEntry updated_at） | ○ |
| C-17 | is_publishedがIconEntry | E-02（IconEntry is_published） | ○ |
| C-18 | category.nameがバッジ表示 | E-02（badge()） | ○ |
| C-19 | categoryがwarning色 | E-02（color warning） | ○ |
| C-20 | tags.nameがバッジ表示 | E-02（badge()） | ○ |
| C-21 | 3カラムレイアウト | E-02（columns(3)） | ○ |
| C-22 | サブナビゲーションが存在 | E-02（SubNavigationPosition::Top） | ○ |
| C-23 | テーブル名はblogs_posts | E-03 | ○ |
| C-24 | 関連機能はFN-BLOG-004 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 表示レイアウトの確認
- [ ] マークダウンレンダリングの確認
- [ ] サブナビゲーションの動作確認
- [ ] バッジ・アイコン表示の確認
