---
generated_at: 2025-12-26 12:00:00
metrics:
  claims_total: 26
  claims_with_evidence: 26
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：58-タグ管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：26 / 26、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/blogs/src/Filament/Admin/Clusters/Configurations/Resources/TagResource/Pages/ManageTags.php`
- E-02: `plugins/webkul/blogs/src/Filament/Admin/Clusters/Configurations/Resources/TagResource.php`
- E-03: `plugins/webkul/blogs/src/Models/Tag.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別は管理画面 | E-01（ManageRecords継承） | ○ |
| C-02 | ヘッダーにCreateActionが存在 | E-01（getHeaderActions） | ○ |
| C-03 | 作成成功通知が表示される | E-01（successNotification） | ○ |
| C-04 | creator_idが自動設定される | E-01（mutateDataUsing） | ○ |
| C-05 | 「すべて」タブが存在 | E-01（getTabs all） | ○ |
| C-06 | 「アーカイブ」タブが存在 | E-01（getTabs archived） | ○ |
| C-07 | タブにバッジ（件数）表示 | E-01（badge Tag::count()） | ○ |
| C-08 | アーカイブはonlyTrashed | E-01（onlyTrashed()） | ○ |
| C-09 | nameフィールドは必須 | E-02（required()） | ○ |
| C-10 | nameフィールドの最大長は255 | E-02（maxLength(255)） | ○ |
| C-11 | nameフィールドは一意 | E-02（unique()） | ○ |
| C-12 | colorフィールドはColorPicker | E-02（ColorPicker::make） | ○ |
| C-13 | colorはhexColor形式 | E-02（hexColor()） | ○ |
| C-14 | nameカラムが存在 | E-02（TextColumn name） | ○ |
| C-15 | colorカラムが存在 | E-02（ColorColumn color） | ○ |
| C-16 | EditAction存在 | E-02（EditAction::make()） | ○ |
| C-17 | DeleteAction存在 | E-02（DeleteAction::make()） | ○ |
| C-18 | RestoreAction存在 | E-02（RestoreAction::make()） | ○ |
| C-19 | ForceDeleteAction存在 | E-02（ForceDeleteAction::make()） | ○ |
| C-20 | DeleteBulkAction存在 | E-02（DeleteBulkAction::make()） | ○ |
| C-21 | RestoreBulkAction存在 | E-02（RestoreBulkAction::make()） | ○ |
| C-22 | ForceDeleteBulkAction存在 | E-02（ForceDeleteBulkAction::make()） | ○ |
| C-23 | テーブル名はblogs_tags | E-03 | ○ |
| C-24 | SoftDeletesを使用 | E-03（use SoftDeletes） | ○ |
| C-25 | SortableTraitを使用 | E-03（use SortableTrait） | ○ |
| C-26 | 関連機能はFN-BLOG-006 | E-05 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] モーダルダイアログでの作成・編集動作確認
- [ ] タブ切替機能の確認
- [ ] ソフトデリート/復元/完全削除機能の確認
- [ ] カラーピッカーの動作確認
