---
generated_at: 2025-12-26 18:05:00
metrics:
  claims_total: 16
  claims_with_evidence: 15
  claims_without_evidence: 1
confidence_derived: 0.94
---

# 根拠レポート：6-銀行口座一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：15 / 16、根拠なし：1
- 優先レビュー（高）
  1. **アクセス方法の詳細**：ナビゲーション設定が無効のため、実際のアクセス経路の確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/accounts/src/Filament/Resources/BankAccountResource/Pages/ListBankAccounts.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/BankAccountResource.php`
- E-03: `plugins/webkul/partners/src/Filament/Resources/BankAccountResource.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | PartnerモジュールのBankAccountResourceを継承 | E-01, E-02 | ○ |
| C-02 | can_send_money列を非表示に設定 | E-02 | ○ |
| C-03 | フォームにaccount_number項目が存在 | E-03 | ○ |
| C-04 | フォームにbank_id項目が存在 | E-03 | ○ |
| C-05 | フォームにpartner_id項目が存在 | E-03 | ○ |
| C-06 | テーブルにaccount_number列が存在 | E-03 | ○ |
| C-07 | テーブルにbank.name列が存在 | E-03 | ○ |
| C-08 | テーブルにpartner.name列が存在 | E-03 | ○ |
| C-09 | ソフトデリート機能を実装 | E-03 | ○ |
| C-10 | 復元アクションが存在 | E-03 | ○ |
| C-11 | 強制削除アクションが存在 | E-03 | ○ |
| C-12 | フィルタ機能が存在 | E-03 | ○ |
| C-13 | グループ化機能が存在 | E-03 | ○ |
| C-14 | テーブル列の並び替え可能 | E-03 | ○ |
| C-15 | ナビゲーション表示が無効 | E-02 | ○ |
| C-16 | 画面へのアクセス方法の詳細経路 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- 画面へのアクセス方法について、shouldRegisterNavigation = falseのため、どのメニューからアクセスするかの詳細経路が不明確
  - 候補：会計クラスター設定 / 別リソースからのリンク / 直接URL

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析に基づく仕様のため、実装との整合性は高い
- 1: 中リスク - ナビゲーション設定が無効のため、実際のユーザーアクセスパスの確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] アクセス経路の確認：どのメニュー/リンクから本画面にアクセスするか
- [ ] 親クラス（PartnerモジュールのBankAccountResource）との差分確認
- [ ] ソフトデリート時の関連データ処理の確認
