---
generated_at: 2025-12-26 12:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：60-カテゴリ一覧（顧客）

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - すべての主張に根拠あり

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/blogs/src/Filament/Customer/Resources/CategoryResource/Pages/ListCategories.php`
- E-02: `plugins/webkul/blogs/src/Filament/Customer/Resources/CategoryResource.php`
- E-03: `plugins/webkul/blogs/src/Models/Category.php`
- E-04: `plugins/webkul/blogs/src/Models/Post.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別は一覧画面 | E-01（ListRecords継承） | ○ |
| C-02 | URLパスは/blog | E-02（$slug = 'blog'） | ○ |
| C-03 | カスタムBladeビューを使用 | E-01（$view定義） | ○ |
| C-04 | shouldSkipAuthorizationがtrue | E-02（$shouldSkipAuthorization） | ○ |
| C-05 | recordRouteKeyNameがslug | E-02（$recordRouteKeyName） | ○ |
| C-06 | getBreadcrumbsが空配列 | E-01（getBreadcrumbs） | ○ |
| C-07 | getRecordsでCategory::all() | E-01（getRecords） | ○ |
| C-08 | getPostsで投稿取得 | E-01（getPosts） | ○ |
| C-09 | 公開済み投稿のみ表示 | E-01（where is_published 1） | ○ |
| C-10 | カテゴリをwith | E-01（with category） | ○ |
| C-11 | 作成者をwith | E-01（with creator） | ○ |
| C-12 | タグをwith | E-01（with tags） | ○ |
| C-13 | タイトルで検索可能 | E-01（where title LIKE） | ○ |
| C-14 | 本文で検索可能 | E-01（where content LIKE） | ○ |
| C-15 | 公開日時降順 | E-01（orderBy published_at desc） | ○ |
| C-16 | ページネーション9件 | E-01（paginate(9)） | ○ |
| C-17 | Categoryモデルを使用 | E-01, E-03 | ○ |
| C-18 | Postモデルを使用 | E-01, E-04 | ○ |
| C-19 | is_publishedはboolean | E-04（casts） | ○ |
| C-20 | reading_timeアクセサ存在 | E-04（getReadingTimeAttribute） | ○ |
| C-21 | 200語/分で計算 | E-04（wordCount / 200） | ○ |
| C-22 | 関連機能はFN-BLOG-008 | E-06 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - すべての主張に十分な根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] カスタムBladeビューの表示確認
- [ ] 検索機能の動作確認
- [ ] ページネーションの動作確認
- [ ] 読了時間の計算確認
- [ ] カテゴリ・投稿詳細への遷移確認
