---
generated_at: 2025-12-26 10:40:00
metrics:
  claims_total: 25
  claims_with_evidence: 25
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：63-パートナー一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：25 / 25、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/contacts/src/Filament/Resources/PartnerResource/Pages/ListPartners.php`
- E-02: `plugins/webkul/partners/src/Filament/Resources/PartnerResource/Pages/ListPartners.php`
- E-03: `plugins/webkul/partners/src/Filament/Resources/PartnerResource.php`
- E-04: `plugins/webkul/partners/src/Models/Partner.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ListPartnersはBaseListPartnersを継承 | E-01 Line 6-10 | ○ |
| C-02 | HasTableViewsトレイトを使用 | E-02 Line 16 | ○ |
| C-03 | 作成ボタンにアイコン付き | E-02 Line 28-30 | ○ |
| C-04 | プリセットビュー: 個人（individual） | E-02 Line 37-40 | ○ |
| C-05 | プリセットビュー: 法人（company） | E-02 Line 42-45 | ○ |
| C-06 | プリセットビュー: アーカイブ済み | E-02 Line 47-50 | ○ |
| C-07 | テーブルはカード形式（Stack）で表示 | E-03 Line 319-381 | ○ |
| C-08 | グループ化機能（account_type, parent, title等） | E-03 Line 383-394 | ○ |
| C-09 | QueryBuilderによるフィルタリング | E-03 Line 396-494 | ○ |
| C-10 | フィルターはモーダル形式 | E-03 Line 495 | ○ |
| C-11 | ViewAction（削除済みは非表示） | E-03 Line 501-503 | ○ |
| C-12 | EditAction（削除済みは非表示） | E-03 Line 504-511 | ○ |
| C-13 | RestoreAction | E-03 Line 512-518 | ○ |
| C-14 | DeleteAction | E-03 Line 519-525 | ○ |
| C-15 | ForceDeleteAction（エラーハンドリング付き） | E-03 Line 526-545 | ○ |
| C-16 | BulkActionGroup（復元、削除、完全削除） | E-03 Line 548-583 | ○ |
| C-17 | account_type != ADDRESS でフィルタ | E-03 Line 585-586 | ○ |
| C-18 | contentGrid レスポンシブ設定 | E-03 Line 588-593 | ○ |
| C-19 | ページネーション設定（16,32,64,all） | E-03 Line 594-599 | ○ |
| C-20 | Partnerモデルのテーブル名 | E-04 Line 33 | ○ |
| C-21 | Partnerモデルのフィールド定義 | E-04 Line 40-66 | ○ |
| C-22 | addressesリレーション（account_type = ADDRESS） | E-04 Line 140-143 | ○ |
| C-23 | contactsリレーション（account_type != ADDRESS） | E-04 Line 145-148 | ○ |
| C-24 | tagsリレーション（多対多） | E-04 Line 157-160 | ○ |
| C-25 | デフォルトソートはcreated_at DESC | E-03 Line 395 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（主要な機能は全てソースコードから確認済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] プリセットビューの切り替え動作確認
- [ ] QueryBuilderフィルターの動作確認
- [ ] 完全削除時の外部キー制約エラーハンドリング確認
- [ ] レスポンシブグリッド表示の確認
