---
generated_at: 2025-12-26 10:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：64-パートナー作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/contacts/src/Filament/Resources/PartnerResource/Pages/CreatePartner.php`
- E-02: `plugins/webkul/partners/src/Filament/Resources/PartnerResource/Pages/CreatePartner.php`
- E-03: `plugins/webkul/partners/src/Filament/Resources/PartnerResource.php`
- E-04: `plugins/webkul/partners/src/Models/Partner.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreatePartnerはBaseCreatePartnerを継承 | E-01 Line 6-10 | ○ |
| C-02 | CreateRecordクラスを継承 | E-02 Line 8 | ○ |
| C-03 | 保存後ViewPartnerへリダイレクト | E-02 Line 23-26 | ○ |
| C-04 | 成功時通知メッセージ | E-02 Line 33-38 | ○ |
| C-05 | account_typeラジオボタン（inline） | E-03 Line 72-85 | ○ |
| C-06 | name入力フィールド（必須、max255） | E-03 Line 86-92 | ○ |
| C-07 | parent_id（個人時のみ表示） | E-03 Line 93-134 | ○ |
| C-08 | avatar FileUpload（imageEditor付き） | E-03 Line 138-145 | ○ |
| C-09 | tax_id入力フィールド | E-03 Line 150-153 | ○ |
| C-10 | job_title入力フィールド | E-03 Line 154-157 | ○ |
| C-11 | phone/mobile入力フィールド（tel） | E-03 Line 158-165 | ○ |
| C-12 | email入力フィールド（unique） | E-03 Line 166-170 | ○ |
| C-13 | website入力フィールド（url） | E-03 Line 171-174 | ○ |
| C-14 | title_id選択（インライン作成可） | E-03 Line 175-192 | ○ |
| C-15 | tags複数選択（インライン作成可） | E-03 Line 193-212 | ○ |
| C-16 | 住所フィールドセット | E-03 Line 214-270 | ○ |
| C-17 | 国選択変更時にstate_idをリセット | E-03 Line 231-237 | ○ |
| C-18 | 営業・購買タブ | E-03 Line 277-310 | ○ |
| C-19 | user_id（担当者）選択 | E-03 Line 284-289 | ○ |
| C-20 | industry_id選択 | E-03 Line 302-304 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（主要な機能は全てソースコードから確認済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] アカウントタイプ切替時の動的表示確認
- [ ] 国選択時の都道府県連動確認
- [ ] メールアドレス一意制約の確認
- [ ] 各インライン作成フォームの動作確認
