---
generated_at: 2025-12-26 10:55:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：66-パートナー詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/contacts/src/Filament/Resources/PartnerResource/Pages/ViewPartner.php`
- E-02: `plugins/webkul/partners/src/Filament/Resources/PartnerResource/Pages/ViewPartner.php`
- E-03: `plugins/webkul/partners/src/Filament/Resources/PartnerResource.php`
- E-04: `plugins/webkul/partners/src/Models/Partner.php`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ViewPartnerはBaseViewPartnerを継承 | E-01 Line 6-10 | ○ |
| C-02 | ViewRecordクラスを継承 | E-02 Line 8 | ○ |
| C-03 | HasRecordNavigationTabsトレイト使用 | E-02 Line 16 | ○ |
| C-04 | ChatterActionヘッダーアクション | E-02 Line 28-29 | ○ |
| C-05 | EditActionヘッダーアクション | E-02 Line 30 | ○ |
| C-06 | DeleteActionヘッダーアクション | E-02 Line 31-37 | ○ |
| C-07 | 削除成功時の通知メッセージ | E-02 Line 32-36 | ○ |
| C-08 | account_typeバッジ表示 | E-03 Line 612-614 | ○ |
| C-09 | name太字大サイズ表示 | E-03 Line 616-618 | ○ |
| C-10 | parent.name表示（個人時のみ） | E-03 Line 620-622 | ○ |
| C-11 | avatar円形表示 | E-03 Line 627-630 | ○ |
| C-12 | 電話・メールアイコン付き表示 | E-03 Line 644-656 | ○ |
| C-13 | タグカラーパレット動的生成 | E-03 Line 668-681 | ○ |
| C-14 | 住所フィールドセット | E-03 Line 684-709 | ○ |
| C-15 | 営業・購買タブ | E-03 Line 712-741 | ○ |
| C-16 | プレースホルダー「—」表示 | E-03 Line 638, 642, 647等 | ○ |
| C-17 | Partnerモデルのリレーション定義 | E-04 Line 100-160 | ○ |
| C-18 | Infolist Schema使用 | E-03 Line 602-744 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（主要な機能は全てソースコードから確認済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] Infolist表示項目の完全性確認
- [ ] タグカラー表示の動作確認
- [ ] ChatterAction機能の動作確認
- [ ] レコードナビゲーションタブの遷移確認
