---
generated_at: 2025-12-26 11:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 18
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：67-住所管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：18 / 18、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/contacts/src/Filament/Resources/PartnerResource/Pages/ManageAddresses.php`
- E-02: `plugins/webkul/partners/src/Filament/Resources/PartnerResource/Pages/ManageAddresses.php`
- E-03: `plugins/webkul/partners/src/Filament/Resources/AddressResource.php`
- E-04: `plugins/webkul/partners/src/Models/Partner.php`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ManageAddressesはBaseManageAddressesを継承 | E-01 Line 6-10 | ○ |
| C-02 | ManageRelatedRecordsクラスを継承 | E-02 Line 5 | ○ |
| C-03 | HasRecordNavigationTabsトレイト使用 | E-02 Line 14 | ○ |
| C-04 | addressesリレーション使用 | E-02 Line 18 | ○ |
| C-05 | マップピンナビゲーションアイコン | E-02 Line 20 | ○ |
| C-06 | AddressResource::form()使用 | E-02 Line 27-29 | ○ |
| C-07 | AddressResource::table()使用 | E-02 Line 31-34 | ○ |
| C-08 | sub_typeラジオボタン（AddressType） | E-03 Line 36-40 | ○ |
| C-09 | name入力フィールド（必須） | E-03 Line 50-53 | ○ |
| C-10 | 住所関連フィールド定義 | E-03 Line 54-76 | ○ |
| C-11 | 国選択時のstate_idリセット | E-03 Line 80-86 | ○ |
| C-12 | CreateAction（account_type自動設定） | E-03 Line 152-167 | ○ |
| C-13 | EditAction（成功通知付き） | E-03 Line 169-176 | ○ |
| C-14 | DeleteAction（成功通知付き） | E-03 Line 177-183 | ○ |
| C-15 | DeleteBulkAction | E-03 Line 185-193 | ○ |
| C-16 | テーブルカラム定義 | E-03 Line 126-150 | ○ |
| C-17 | addressesリレーション定義（account_type = ADDRESS） | E-04 Line 140-143 | ○ |
| C-18 | creator_id自動設定 | E-03 Line 158 | ○ |

## 4) 不足情報（Unknown / Missing）
- AddressType Enumの詳細定義（ファイルパス要確認）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] 住所タイプ（sub_type）の選択肢確認
- [ ] 国選択時の都道府県連動確認
- [ ] 各CRUD操作の動作確認
- [ ] 一括削除機能の動作確認
