---
generated_at: 2025-12-26 11:10:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：69-銀行口座管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/contacts/src/Filament/Clusters/Configurations/Resources/BankAccountResource/Pages/ManageBankAccounts.php`
- E-02: `plugins/webkul/partners/src/Filament/Resources/BankAccountResource/Pages/ManageBankAccounts.php`
- E-03: `plugins/webkul/partners/src/Filament/Resources/BankAccountResource.php`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | ManageBankAccountsはBaseManageBankAccountsを継承 | E-01 Line 6-10 | ○ |
| C-02 | ManageRecordsクラスを継承 | E-02 Line 7 | ○ |
| C-03 | CreateAction（ヘッダーアクション） | E-02 Line 20-33 | ○ |
| C-04 | creator_id mutateDataUsingで設定 | E-02 Line 23-27 | ○ |
| C-05 | 作成成功時の通知メッセージ | E-02 Line 28-32 | ○ |
| C-06 | タブ: 全件（件数バッジ付き） | E-02 Line 40-41 | ○ |
| C-07 | タブ: アーカイブ済み（onlyTrashed） | E-02 Line 42-46 | ○ |
| C-08 | account_number（必須、一意） | E-03 Line 50-53 | ○ |
| C-09 | can_send_money Toggle | E-03 Line 54-56 | ○ |
| C-10 | bank_id Select（必須、インライン作成可） | E-03 Line 57-74 | ○ |
| C-11 | partner_id Select（必須） | E-03 Line 75-83 | ○ |
| C-12 | 銀行選択にwithTrashed適用 | E-03 Line 60-63 | ○ |
| C-13 | 削除済み銀行の選択不可（disableOptionWhen） | E-03 Line 68-70 | ○ |
| C-14 | reorderableColumns有効 | E-03 Line 90 | ○ |
| C-15 | テーブルカラム定義 | E-03 Line 91-123 | ○ |
| C-16 | グループ化機能 | E-03 Line 125-133 | ○ |
| C-17 | フィルター機能 | E-03 Line 134-151 | ○ |
| C-18 | EditAction（削除済み非表示） | E-03 Line 153-161 | ○ |
| C-19 | RestoreAction | E-03 Line 162-168 | ○ |
| C-20 | DeleteAction | E-03 Line 169-175 | ○ |
| C-21 | ForceDeleteAction | E-03 Line 176-182 | ○ |
| C-22 | BulkActionGroup（復元、削除、完全削除） | E-03 Line 184-207 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし（主要な機能は全てソースコードから確認済み）

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張がソースコードから確認済み

## 6) レビュアーチェックリスト（最小）
- [ ] タブ切替の動作確認（全件/アーカイブ済み）
- [ ] 銀行インライン作成の動作確認
- [ ] 削除済み銀行の選択不可確認
- [ ] 各フィルター・グループ化の動作確認
