---
generated_at: 2025-12-26 18:06:00
metrics:
  claims_total: 14
  claims_with_evidence: 13
  claims_without_evidence: 1
confidence_derived: 0.93
---

# 根拠レポート：7-請求書一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.93**
  - 根拠あり：13 / 14、根拠なし：1
- 優先レビュー（高）
  1. **テーブル表示項目の詳細確認**：InvoiceResource::table()の実装詳細が未確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/accounts/src/Filament/Resources/BillResource/Pages/ListBills.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/BillResource.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-04: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | InvoiceResourceのListInvoicesを継承 | E-01 | ○ |
| C-02 | HasTableViewsトレイトを使用 | E-01 | ○ |
| C-03 | ヘッダーにCreateActionが存在 | E-01 | ○ |
| C-04 | プリセットビューにbillが存在 | E-01 | ○ |
| C-05 | billビューはmove_type = IN_INVOICEでフィルタ | E-01 | ○ |
| C-06 | billビューがデフォルトかつお気に入り設定 | E-01 | ○ |
| C-07 | 親のinvoiceビューを除外 | E-01 | ○ |
| C-08 | テーブルはInvoiceResource::tableを使用 | E-02 | ○ |
| C-09 | モデルはAccountMove | E-02 | ○ |
| C-10 | レコード識別属性はname | E-02 | ○ |
| C-11 | ナビゲーション表示が無効 | E-02 | ○ |
| C-12 | URLは/accounts/bills | E-02 | ○ |
| C-13 | 画面一覧でNo.7として登録 | E-03 | ○ |
| C-14 | テーブル表示項目の詳細 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- テーブル表示項目の詳細について、InvoiceResource::table()の実装を直接確認していないため、表示項目リストは推定
  - 候補：InvoiceResourceソースコードの確認 / 実際の画面での確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析に基づく仕様のため、実装との整合性は高い
- 1: 中リスク - テーブル表示項目はInvoiceResourceからの継承のため、詳細確認が必要

## 6) レビュアーチェックリスト（最小）
- [ ] InvoiceResource::table()のテーブル列定義の確認
- [ ] プリセットビューの動作確認
- [ ] MoveState, PaymentState Enumの値一覧の確認
