---
generated_at: 2025-12-26 18:00:00
metrics:
  claims_total: 18
  claims_with_evidence: 16
  claims_without_evidence: 2
confidence_derived: 0.89
---

# 根拠レポート：71-敬称管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.89**
  - 根拠あり：16 / 18、根拠なし：2
- 優先レビュー（高）
  1. **URL/ルーティング**：実際のルーティング設定ファイル未確認
  2. **参照整合性エラー処理**：外部キー制約の実装確認が必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/contacts/src/Filament/Clusters/Configurations/Resources/TitleResource/Pages/ManageTitles.php`
- E-02: `plugins/webkul/partners/src/Filament/Resources/TitleResource/Pages/ManageTitles.php`
- E-03: `plugins/webkul/partners/src/Filament/Resources/TitleResource.php`
- E-04: `plugins/webkul/partners/src/Models/Title.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「敬称管理」である | E-05 | ○ |
| C-02 | ManageRecordsページタイプを使用 | E-02 | ○ |
| C-03 | TitleResourceを継承している | E-01, E-02 | ○ |
| C-04 | nameフィールドは必須で最大255文字 | E-03 | ○ |
| C-05 | short_nameフィールドは必須で最大255文字 | E-03 | ○ |
| C-06 | 作成時にcreator_idが自動設定される | E-02 | ○ |
| C-07 | テーブル名はpartners_titles | E-04 | ○ |
| C-08 | fillableにname, short_name, creator_idが含まれる | E-04 | ○ |
| C-09 | 編集・削除アクションが存在する | E-03 | ○ |
| C-10 | 一括削除機能が存在する | E-03 | ○ |
| C-11 | 検索機能はnameとshort_nameに対応 | E-03 | ○ |
| C-12 | created_at/updated_atはデフォルト非表示 | E-03 | ○ |
| C-13 | 成功通知が表示される | E-02, E-03 | ○ |
| C-14 | 連絡先モジュールの設定クラスター配下 | E-01 | ○ |
| C-15 | パートナー作成画面から敬称選択時に参照される | E-06 | ○ |
| C-16 | ソート可能なカラムはcreated_at, updated_at | E-03 | ○ |
| C-17 | URL/ルーティングは/contacts/configurations/titles | **根拠なし** | △ |
| C-18 | 参照整合性エラー時に削除失敗メッセージを表示 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- URL/ルーティングの正確なパス
  - 候補：ルーティング設定ファイル / Filament Panel設定
- 外部キー制約によるエラーハンドリング実装
  - 候補：マイグレーションファイル / 例外処理コード

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 基本的なCRUD機能は確認済み
- 1: 中リスク - URL/ルーティングは推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] URL/ルーティングパスが正しいか確認
- [ ] 敬称が使用中の場合の削除時エラーハンドリングを確認
- [ ] 多言語対応のラベルが正しく設定されているか確認
