---
generated_at: 2025-12-26 18:05:00
metrics:
  claims_total: 22
  claims_with_evidence: 20
  claims_without_evidence: 2
confidence_derived: 0.91
---

# 根拠レポート：72-業種管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.91**
  - 根拠あり：20 / 22、根拠なし：2
- 優先レビュー（高）
  1. **URL/ルーティング**：実際のルーティング設定ファイル未確認
  2. **is_active/can_send_moneyフィールド**：モデルに存在するが画面で使用されているか要確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/contacts/src/Filament/Clusters/Configurations/Resources/IndustryResource/Pages/ManageIndustries.php`
- E-02: `plugins/webkul/partners/src/Filament/Resources/IndustryResource/Pages/ManageIndustries.php`
- E-03: `plugins/webkul/partners/src/Filament/Resources/IndustryResource.php`
- E-04: `plugins/webkul/partners/src/Models/Industry.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-06: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「業種管理」である | E-05 | ○ |
| C-02 | ManageRecordsページタイプを使用 | E-02 | ○ |
| C-03 | SoftDeletesトレイトを使用 | E-04 | ○ |
| C-04 | nameフィールドは必須で最大255文字、ユニーク | E-03 | ○ |
| C-05 | descriptionフィールドは必須で最大255文字、ユニーク | E-03 | ○ |
| C-06 | 作成時にcreator_idが自動設定される | E-02 | ○ |
| C-07 | テーブル名はpartners_industries | E-04 | ○ |
| C-08 | 「すべて」と「アーカイブ」タブが存在する | E-02 | ○ |
| C-09 | タブにレコード件数バッジが表示される | E-02 | ○ |
| C-10 | 編集アクションはアーカイブ時に非表示 | E-03 | ○ |
| C-11 | 復元アクションが存在する | E-03 | ○ |
| C-12 | 完全削除（ForceDelete）アクションが存在する | E-03 | ○ |
| C-13 | 一括削除機能が存在する | E-03 | ○ |
| C-14 | 一括復元機能が存在する | E-03 | ○ |
| C-15 | 一括完全削除機能が存在する | E-03 | ○ |
| C-16 | 検索機能はnameとdescriptionに対応 | E-03 | ○ |
| C-17 | ソート機能はnameとdescriptionに対応 | E-03 | ○ |
| C-18 | 成功通知が表示される | E-02, E-03 | ○ |
| C-19 | 連絡先モジュールの設定クラスター配下 | E-01 | ○ |
| C-20 | IndustryResourceを継承している | E-01, E-02 | ○ |
| C-21 | URL/ルーティングは/contacts/configurations/industries | **根拠なし** | △ |
| C-22 | is_activeとcan_send_moneyフィールドが存在する | E-04（モデルのみ） | △ |

## 4) 不足情報（Unknown / Missing）
- URL/ルーティングの正確なパス
  - 候補：ルーティング設定ファイル / Filament Panel設定
- is_active/can_send_moneyフィールドの画面での使用有無
  - 候補：フォームフィールド定義の詳細確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソフトデリート機能は確認済み
- 1: 中リスク - URL/ルーティングは推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] URL/ルーティングパスが正しいか確認
- [ ] ユニーク制約のバリデーションエラーメッセージを確認
- [ ] is_active/can_send_moneyフィールドの用途を確認
- [ ] 業種が使用中の場合の削除時エラーハンドリングを確認
