---
generated_at: 2025-12-26 18:10:00
metrics:
  claims_total: 25
  claims_with_evidence: 23
  claims_without_evidence: 2
confidence_derived: 0.92
---

# 根拠レポート：73-銀行管理

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.92**
  - 根拠あり：23 / 25、根拠なし：2
- 優先レビュー（高）
  1. **URL/ルーティング**：実際のルーティング設定ファイル未確認
  2. **テーブル名**：banksテーブルの正式名を確認

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/contacts/src/Filament/Clusters/Configurations/Resources/BankResource/Pages/ManageBanks.php`
- E-02: `plugins/webkul/partners/src/Filament/Resources/BankResource/Pages/ManageBanks.php`
- E-03: `plugins/webkul/partners/src/Filament/Resources/BankResource.php`
- E-04: `plugins/webkul/partners/src/Models/Bank.php`
- E-05: `plugins/webkul/support/src/Models/Bank.php`
- E-06: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-07: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面名は「銀行管理」である | E-06 | ○ |
| C-02 | ManageRecordsページタイプを使用 | E-02 | ○ |
| C-03 | SoftDeletesトレイトを使用 | E-05 | ○ |
| C-04 | nameフィールドは必須で最大255文字 | E-03 | ○ |
| C-05 | codeフィールドは任意で最大255文字 | E-03 | ○ |
| C-06 | emailフィールドはemail型 | E-03 | ○ |
| C-07 | phoneフィールドはtel型 | E-03 | ○ |
| C-08 | 国と州のカスケード選択が実装されている | E-03 | ○ |
| C-09 | 作成時にcreator_idが自動設定される | E-02 | ○ |
| C-10 | fillableにname,code,email,phone,street1,street2,city,zip等が含まれる | E-05 | ○ |
| C-11 | 「すべて」と「アーカイブ」タブが存在する | E-02 | ○ |
| C-12 | タブにレコード件数バッジが表示される | E-02 | ○ |
| C-13 | 編集アクションはアーカイブ時に非表示 | E-03 | ○ |
| C-14 | 復元アクションが存在する | E-03 | ○ |
| C-15 | 完全削除アクションが存在する | E-03 | ○ |
| C-16 | 一括削除・復元・完全削除機能が存在する | E-03 | ○ |
| C-17 | 検索機能はnameとcodeに対応 | E-03 | ○ |
| C-18 | ソート機能はname,code,country.nameに対応 | E-03 | ○ |
| C-19 | グループ化機能（国別・作成日別） | E-03 | ○ |
| C-20 | フォームは2セクション構成（基本情報・住所情報） | E-03 | ○ |
| C-21 | 各セクションは2カラムレイアウト | E-03 | ○ |
| C-22 | 成功通知が表示される | E-02, E-03 | ○ |
| C-23 | BankResourceはSupportモジュールのBankモデルを継承 | E-04, E-05 | ○ |
| C-24 | URL/ルーティングは/contacts/configurations/banks | **根拠なし** | △ |
| C-25 | テーブル名はbanks | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- URL/ルーティングの正確なパス
  - 候補：ルーティング設定ファイル / Filament Panel設定
- テーブル名の正式名（banksまたはsupport_banks等）
  - 候補：マイグレーションファイル

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - ソフトデリート・グループ化機能は確認済み
- 1: 中リスク - URL/ルーティングとテーブル名は推測に基づく

## 6) レビュアーチェックリスト（最小）
- [ ] URL/ルーティングパスが正しいか確認
- [ ] テーブル名をマイグレーションファイルで確認
- [ ] 国・州のカスケード選択が正しく動作するか確認
- [ ] 銀行口座で使用中の銀行削除時のエラーハンドリングを確認
