---
generated_at: 2025-12-26 18:07:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：8-請求書作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし（すべての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `plugins/webkul/accounts/src/Filament/Resources/BillResource/Pages/CreateBill.php`
- E-02: `plugins/webkul/accounts/src/Filament/Resources/BillResource.php`
- E-03: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面クラスはCreateRecordを継承 | E-01 | ○ |
| C-02 | 保存成功後にViewBillへリダイレクト | E-01 | ○ |
| C-03 | 成功通知を表示 | E-01 | ○ |
| C-04 | move_typeはIN_INVOICEが自動設定 | E-01 | ○ |
| C-05 | dateは現在日時が自動設定 | E-01 | ○ |
| C-06 | 保存後にcomputeAccountMoveが実行 | E-01 | ○ |
| C-07 | フォームにPartner選択が存在 | E-02 | ○ |
| C-08 | Partner選択でsub_type=supplierフィルタ | E-02 | ○ |
| C-09 | フォームにinvoice_date項目が存在 | E-02 | ○ |
| C-10 | フォームにreference項目が存在 | E-02 | ○ |
| C-11 | フォームにpayment_reference項目が存在 | E-02 | ○ |
| C-12 | フォームにpartner_bank_id項目が存在 | E-02 | ○ |
| C-13 | フォームにinvoice_date_due項目が存在 | E-02 | ○ |
| C-14 | フォームにinvoice_payment_term_id項目が存在 | E-02 | ○ |
| C-15 | 請求明細リピーターが存在 | E-02 | ○ |
| C-16 | 明細行に商品、数量、単価等が存在 | E-02 | ○ |
| C-17 | InvoiceSummaryコンポーネントが存在 | E-02 | ○ |
| C-18 | その他情報タブにインコタームズ設定が存在 | E-02 | ○ |
| C-19 | その他情報タブに支払方法設定が存在 | E-02 | ○ |
| C-20 | その他情報タブに会社、通貨設定が存在 | E-02 | ○ |
| C-21 | 利用規約タブにnarration項目が存在 | E-02 | ○ |
| C-22 | 画面一覧でNo.8として登録 | E-03 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コード解析に基づく仕様のため、実装との整合性は高い

## 6) レビュアーチェックリスト（最小）
- [ ] 仕入先選択時の自動設定動作の確認
- [ ] 商品選択時の税・単価自動設定の確認
- [ ] 会計計算（computeAccountMove）の結果確認
- [ ] 税計算ロジック（Tax::collect）の動作確認
