---
generated_at: 2025-12-26 18:35:00
metrics:
  claims_total: 30
  claims_with_evidence: 30
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：88-アクティビティプラン一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：30 / 30、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/ActivityPlanResource/Pages/ListActivityPlans.php`
- E-02: `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/ActivityPlanResource.php`
- E-03: `plugins/webkul/employees/src/Models/ActivityPlan.php`
- E-04: `plugins/webkul/support/src/Models/ActivityPlan.php`
- E-05: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別がListRecords | E-01 L7 | ○ |
| C-02 | Configurationsクラスターに属する | E-02 L52 | ○ |
| C-03 | pluginName='employees' | E-01 L17 | ○ |
| C-04 | headerActionsにCreateAction | E-01 L24-46 | ○ |
| C-05 | mutateDataUsingでplugin/creator_id/company_id設定 | E-01 L30-38 | ○ |
| C-06 | getTabs()でall/archivedタブ | E-01 L50-60 | ○ |
| C-07 | タブにpluginフィルタ適用 | E-01 L54,56 | ○ |
| C-08 | archivedタブでonlyTrashed | E-01 L57-58 | ○ |
| C-09 | テーブルカラム定義 | E-02 L101-131 | ○ |
| C-10 | nameカラム | E-02 L102-104 | ○ |
| C-11 | department.nameカラム | E-02 L105-107 | ○ |
| C-12 | department.manager.nameカラム | E-02 L108-110 | ○ |
| C-13 | company.nameカラム | E-02 L111-113 | ○ |
| C-14 | is_activeアイコン | E-02 L114-117 | ○ |
| C-15 | TernaryFilter | E-02 L134-135 | ○ |
| C-16 | QueryBuilder | E-02 L136-185 | ○ |
| C-17 | グループ化機能 | E-02 L187-203 | ○ |
| C-18 | 行アクション（view/edit非表示条件） | E-02 L206-209 | ○ |
| C-19 | 行アクション（restore/delete/forceDelete） | E-02 L210-230 | ○ |
| C-20 | 一括アクション | E-02 L232-255 | ○ |
| C-21 | emptyStateActions | E-02 L257-276 | ○ |
| C-22 | modifyQueryUsing | E-02 L278-280 | ○ |
| C-23 | フォーム項目name | E-02 L65-68 | ○ |
| C-24 | フォーム項目department_id | E-02 L69-75 | ○ |
| C-25 | フォーム項目company_id | E-02 L76-87 | ○ |
| C-26 | フォーム項目is_active | E-02 L88-91 | ○ |
| C-27 | reorderableColumns | E-02 L99 | ○ |
| C-28 | columnManagerColumns(2) | E-02 L100 | ○ |
| C-29 | SoftDeletes使用（ベースモデル） | E-04 L15 | ○ |
| C-30 | 画面一覧での定義 | E-05 L89 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 標準的なFilament ListRecords実装
- 1: 中リスク - 複数プラグインでの共通テーブル使用（データ分離の確認推奨）

## 6) レビュアーチェックリスト（最小）
- [ ] pluginフィルタが正しく適用されるか確認
- [ ] 論理削除済みレコードで表示/編集ボタンが非表示になるか確認
- [ ] 部署・会社のインラインフォームが正しく動作するか確認
- [ ] カラムの並べ替えが保存されるか確認
