---
generated_at: 2025-12-26 18:45:00
metrics:
  claims_total: 20
  claims_with_evidence: 20
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：90-アクティビティプラン詳細

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：20 / 20、根拠なし：0
- 優先レビュー（高）
  - なし（全ての主張に根拠あり）

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/ActivityPlanResource/Pages/ViewActivityPlan.php`
- E-02: `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/ActivityPlanResource.php`
- E-03: `plugins/webkul/support/src/Models/ActivityPlan.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 画面種別がViewRecord | E-01 L8 | ○ |
| C-02 | URLが/employees/configurations/activity-plans/{record} | E-02 L324 | ○ |
| C-03 | ヘッダーにEditAction | E-01 L27 | ○ |
| C-04 | ヘッダーにDeleteAction | E-01 L28-34 | ○ |
| C-05 | 削除成功通知を表示 | E-01 L29-33 | ○ |
| C-06 | getSubNavigation()実装 | E-01 L15-22 | ○ |
| C-07 | infolistでname表示 | E-02 L289-292 | ○ |
| C-08 | infolistでdepartment.name表示 | E-02 L293-296 | ○ |
| C-09 | infolistでdepartment.manager.name表示 | E-02 L297-300 | ○ |
| C-10 | infolistでcompany.name表示 | E-02 L301-304 | ○ |
| C-11 | infolistでis_active表示（IconEntry） | E-02 L305-307 | ○ |
| C-12 | nameにheroicon-o-briefcase | E-02 L291 | ○ |
| C-13 | department.nameにheroicon-o-building-office-2 | E-02 L294 | ○ |
| C-14 | department.manager.nameにheroicon-o-user | E-02 L298 | ○ |
| C-15 | company.nameにheroicon-o-building-office | E-02 L302 | ○ |
| C-16 | placeholder('—')設定 | E-02 L290,295,299,303 | ○ |
| C-17 | 2カラムレイアウト | E-02 L309 | ○ |
| C-18 | getRelations()定義 | E-02 L313-317 | ○ |
| C-19 | SoftDeletes使用（ベースモデル） | E-03 L15 | ○ |
| C-20 | 画面一覧での定義 | E-04 L91 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 読み取り専用の表示画面
- 0: 低リスク - 標準的なFilament ViewRecord実装

## 6) レビュアーチェックリスト（最小）
- [ ] 各項目のアイコンが正しく表示されるか確認
- [ ] ネストされたリレーション（department.manager.name）が正しく表示されるか確認
- [ ] is_activeのアイコンが正しく表示されるか確認
- [ ] リレーションマネージャーが正しく機能するか確認
- [ ] サブナビゲーションが正しく機能するか確認
