---
generated_at: 2025-12-26 12:00:00
metrics:
  claims_total: 25
  claims_with_evidence: 24
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：91-職位一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：24 / 25、根拠なし：1
- 優先レビュー（高）
  1. **URL/ルーティング**：推測に基づく部分あり

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/JobPositionResource/Pages/ListJobPositions.php`
- E-02: `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/JobPositionResource.php`
- E-03: `plugins/webkul/employees/src/Models/EmployeeJobPosition.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`
- E-05: `docs/code-to-docs/画面機能マッピング/画面機能マッピング.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | 職位一覧画面が存在する | E-01, E-04 | ○ |
| C-02 | ListRecordsを継承している | E-01 | ○ |
| C-03 | HasTableViewsトレイトを使用 | E-01 | ○ |
| C-04 | マイ部署プリセットビューが存在 | E-01 | ○ |
| C-05 | アーカイブ済みプリセットビューが存在 | E-01 | ○ |
| C-06 | ヘッダーに作成ボタンが存在 | E-01, E-02 | ○ |
| C-07 | ID列が存在（デフォルト非表示） | E-02 | ○ |
| C-08 | 職位名列が存在 | E-02 | ○ |
| C-09 | 部署名列が存在 | E-02 | ○ |
| C-10 | 会社名列が存在 | E-02 | ○ |
| C-11 | ステータス列が存在 | E-02 | ○ |
| C-12 | 削除アクションが存在 | E-02 | ○ |
| C-13 | 復元アクションが存在 | E-02 | ○ |
| C-14 | 一括削除アクションが存在 | E-02 | ○ |
| C-15 | 強制削除アクションが存在 | E-02 | ○ |
| C-16 | 並び替え機能が存在 | E-02 | ○ |
| C-17 | SoftDeletesを使用 | E-03 | ○ |
| C-18 | employees_job_positionsテーブルを使用 | E-03 | ○ |
| C-19 | 部署フィルタが存在 | E-02 | ○ |
| C-20 | 雇用形態フィルタが存在 | E-02 | ○ |
| C-21 | 会社フィルタが存在 | E-02 | ○ |
| C-22 | ステータスフィルタが存在 | E-02 | ○ |
| C-23 | グルーピング機能が存在 | E-02 | ○ |
| C-24 | 職位管理機能と関連 | E-05 | ○ |
| C-25 | URL: /employees/configurations/job-positions | **推測** | △ |

## 4) 不足情報（Unknown / Missing）
- URL/ルーティングの完全なパスはコードから直接確認できず、Filamentの命名規則とClusterの設定から推測
  - 候補：JobPositionResource::getPages() / Configurations Cluster

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全体的にソースコードとの整合性が高い

## 6) レビュアーチェックリスト（最小）
- [ ] URL/ルーティングの実際のパスを確認
- [ ] 多言語対応のラベルが正しく表示されるか確認
