---
generated_at: 2025-12-26 12:01:00
metrics:
  claims_total: 22
  claims_with_evidence: 22
  claims_without_evidence: 0
confidence_derived: 1.00
---

# 根拠レポート：92-職位作成

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**1.00**
  - 根拠あり：22 / 22、根拠なし：0
- 優先レビュー（高）
  - なし

## 2) 参照した情報（Evidence一覧）

- E-01: `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/JobPositionResource/Pages/CreateJobPosition.php`
- E-02: `plugins/webkul/employees/src/Filament/Clusters/Configurations/Resources/JobPositionResource.php`
- E-03: `plugins/webkul/employees/src/Models/EmployeeJobPosition.php`
- E-04: `docs/code-to-docs/画面一覧/画面一覧.csv`

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | CreateRecordを継承している | E-01 | ○ |
| C-02 | JobPositionResourceをリソースとして使用 | E-01 | ○ |
| C-03 | 作成後に詳細画面へリダイレクト | E-01 getRedirectUrl() | ○ |
| C-04 | 作成通知が表示される | E-01 getCreatedNotification() | ○ |
| C-05 | creator_idが自動設定される | E-01 mutateFormDataBeforeCreate() | ○ |
| C-06 | 職位名フィールドが存在（必須、255文字） | E-02 form() | ○ |
| C-07 | 部署選択フィールドが存在 | E-02 form() | ○ |
| C-08 | 会社選択フィールドが存在 | E-02 form() | ○ |
| C-09 | 部署選択時に会社が自動設定される | E-02 afterStateUpdated | ○ |
| C-10 | 部署の新規作成モーダルが存在 | E-02 createOptionForm | ○ |
| C-11 | 会社の新規作成モーダルが存在 | E-02 createOptionForm | ○ |
| C-12 | 職務内容（RichEditor）が存在 | E-02 form() | ○ |
| C-13 | 必要要件（RichEditor）が存在 | E-02 form() | ○ |
| C-14 | 採用目標人数フィールドが存在 | E-02 form() | ○ |
| C-15 | 雇用形態選択フィールドが存在 | E-02 form() | ○ |
| C-16 | ステータストグルが存在 | E-02 form() | ○ |
| C-17 | 3カラムレイアウトを使用 | E-02 form() columns(3) | ○ |
| C-18 | employees_job_positionsテーブルを使用 | E-03 | ○ |
| C-19 | SoftDeletesトレイトを使用 | E-03 | ○ |
| C-20 | SortableTraitを使用 | E-03 | ○ |
| C-21 | サブナビゲーションが表示される | E-01 getSubNavigation() | ○ |
| C-22 | 画面一覧に登録されている | E-04 | ○ |

## 4) 不足情報（Unknown / Missing）
- なし

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 全ての主張にソースコードによる根拠あり

## 6) レビュアーチェックリスト（最小）
- [ ] 実際の画面で部署→会社の連動動作を確認
- [ ] 作成成功時の通知メッセージが正しく表示されるか確認
